"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("kdweb-core/lib/utils");
const moment = require("moment");
const config_1 = require("../config");
const log_1 = require("../log");
const LoopHelper_1 = require("./LoopHelper");
let aday = 24 * 3600000;
class LooperBase {
    constructor() {
        this.ready_ = false;
        this.prevLoopTime_ = null;
        this.isWorking_ = false;
        this.prevLoopTime_ = 0;
        this.init();
    }
    getTimeCacheName() {
        return "looper-default-time";
    }
    getUpdateInterval() {
        return 60000;
    }
    getTargetTimeWithConfig() {
        return 0;
    }
    init() {
        return __awaiter(this, void 0, void 0, function* () {
            let prevTime = yield LoopHelper_1.LoopHelper.getNum(this.getTimeCacheName());
            let targetTime = this.getTodayTimeTarget();
            log_1.Log.oth.info("target time = " + targetTime);
            if (prevTime) {
                // 上一次的时间没有越过今天的线
                if (prevTime < targetTime) {
                    yield this.work();
                }
                else {
                    this.prevLoopTime_ = prevTime;
                }
            }
            else {
                yield this.work();
            }
            this.ready_ = true;
            let self = this;
            setInterval(function () {
                self.onUpdate();
            }, this.getUpdateInterval());
            this.onUpdate();
        });
    }
    get ready() {
        return this.ready_;
    }
    onUpdate() {
        if (this.isWorking_) {
            return;
        }
        if (this.prevLoopTime_ < this.getTodayTimeTarget()) {
            this.work();
        }
    }
    getTodayTimeTarget() {
        let date = utils_1.kdutils.getFmtMoment("YYYY-MM-DD");
        date += " " + (config_1.Config.localConfig.tea.fundLoopTime || 0) + ":00:00";
        let time = Number.parseInt(moment(date, "YYYY-MM-DD HH:mm:ss").format("x"));
        return time;
    }
    work() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.isWorking_) {
                return;
            }
            this.isWorking_ = true;
            try {
                yield this.workWithLastDay(0);
                let time = utils_1.kdutils.getMillionSecond();
                yield LoopHelper_1.LoopHelper.setNum(this.getTimeCacheName(), time);
                this.prevLoopTime_ = time;
            }
            catch (error) {
                log_1.Log.oth.error("[fund-looper] error in working = ", error);
            }
            finally {
                this.isWorking_ = false;
            }
        });
    }
    /**
     * 生成据今几天前的数据
     * 0就是今天时间点之前一天的数据
     * @param lastCount [0~any)
     */
    workWithLastDay(lastCount) {
        return __awaiter(this, void 0, void 0, function* () {
        });
    }
}
exports.LooperBase = LooperBase;
