"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("kdweb-core/lib/utils");
const ServerConfig_1 = require("../../../kds-base-define/src/ServerConfig");
const billUtils_1 = require("../billUtils");
const config_1 = require("../config");
const db_1 = require("../db");
const log_1 = require("../log");
const LooperBase_1 = require("./LooperBase");
let aday = 24 * 3600000;
let teaUserTablename = "t_tea_user_daily_bill";
class TeaUserBillLooper extends LooperBase_1.LooperBase {
    getTimeCacheName() {
        return "user-bill-loop-prev-time";
    }
    getUpdateInterval() {
        return 60000;
    }
    getTargetTimeWithConfig() {
        return config_1.Config.localConfig.tea.fundLoopTime || 2;
    }
    /**
     * 生成据今几天前的数据
     * 0就是今天时间点之前一天的数据
     * @param lastCount [0~any)
     */
    workWithLastDay(lastCount) {
        return __awaiter(this, void 0, void 0, function* () {
            log_1.Log.oth.info("[tea-user-bill] start looper");
            lastCount = lastCount != null ? lastCount : 0;
            let startTime = this.getTodayTimeTarget() - lastCount * aday;
            let endTime = startTime - aday;
            let db = db_1.DB.get(ServerConfig_1.ServerValues.dbBill, "tea-user-bill-looper");
            let redis = db_1.DB.redis;
            let teaDatas = yield redis.hgetall("t_tea_data", true);
            let teaIDs = Object.keys(teaDatas);
            log_1.Log.oth.info("[tea-user-bill] tea count = " + teaIDs.length);
            for (let key of teaIDs) {
                log_1.Log.oth.info("[tea-user-bill] teaID = " + key);
                let teaData = teaDatas[key];
                let member = yield redis.hget("t_tea_member", key, true);
                let bills = yield db.get(billUtils_1.BillUtils.billTablename, {
                    "roomPOData.roomData.teaExt.teaID": teaData.teaID,
                    startTimestamp: {
                        $gte: endTime,
                        $lt: startTime,
                    }
                });
                if (bills == null) {
                    log_1.Log.oth.error("[tea-user-bill] cannot get bills teaID = " + key);
                    continue;
                }
                let ret = {
                    teaID: teaData.teaID,
                    items: [],
                    // 前一天的日期
                    timestamp: endTime,
                    // 前一天的日期
                    date: utils_1.kdutils.getFmtMoment("YYYY-MM-DD", endTime),
                };
                for (let bill of bills) {
                    for (let user of bill.users) {
                        if (member.members.find(v => v.userID == user.userID) == null) {
                            continue;
                        }
                        let item = ret.items.find(v => v.userID == user.userID);
                        if (item == null) {
                            item = {
                                userID: user.userID,
                                nickName: user.nickName,
                                dayScore: 0,
                                dayCount: 0,
                            };
                            ret.items.push(item);
                        }
                        item.dayCount++;
                        let scoreInfo = bill.scores.find(v => v.userID == user.userID);
                        if (scoreInfo) {
                            item.dayScore += scoreInfo.score;
                        }
                    }
                }
                let count = yield db.delMany(teaUserTablename, {
                    teaID: ret.teaID,
                    date: ret.date,
                });
                log_1.Log.oth.info("[tea-user-bill] del teaID = " + ret.teaID + " date =" + ret.date + " count = " + count);
                yield db.insert(teaUserTablename, ret);
            }
        });
    }
}
exports.TeaUserBillLooper = TeaUserBillLooper;
let cache = new Map();
function getCacheKey(teaID, date) {
    return teaID + "|" + date;
}
(function (TeaUserBillLooper) {
    TeaUserBillLooper.instance = null;
    function start() {
        TeaUserBillLooper.instance = new TeaUserBillLooper();
    }
    TeaUserBillLooper.start = start;
    /**
     *
     * @param teaID
     * @param lastCount [0~any)
     */
    function getPrevDateBill(teaID, lastCount) {
        return __awaiter(this, void 0, void 0, function* () {
            let time = utils_1.kdutils.getMillionSecond();
            time -= aday * (lastCount + 1);
            let date = utils_1.kdutils.getFmtMoment("YYYY-MM-DD", time);
            let key = getCacheKey(teaID, date);
            if (cache.has(key)) {
                return cache.get(key);
            }
            let db = billUtils_1.BillUtils.dbBill;
            let ret = yield db.getSingle(teaUserTablename, {
                teaID: teaID,
                date: date
            });
            if (ret) {
                cache.set(key, ret);
            }
            return ret;
        });
    }
    TeaUserBillLooper.getPrevDateBill = getPrevDateBill;
})(TeaUserBillLooper = exports.TeaUserBillLooper || (exports.TeaUserBillLooper = {}));
