"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var MatchDefine;
(function (MatchDefine) {
    let CostType;
    (function (CostType) {
        CostType[CostType["Gold"] = 0] = "Gold";
        CostType[CostType["Diamond"] = 1] = "Diamond";
        CostType[CostType["Item"] = 2] = "Item";
        CostType[CostType["Nothing"] = 256] = "Nothing";
    })(CostType = MatchDefine.CostType || (MatchDefine.CostType = {}));
    let LogicType;
    (function (LogicType) {
        /**
         * count: 等待多少人才开始匹配
         * time: 人不齐到超时，直接匹配
         */
        LogicType[LogicType["WaitTimeout"] = 0] = "WaitTimeout";
    })(LogicType = MatchDefine.LogicType || (MatchDefine.LogicType = {}));
    let MatchType;
    (function (MatchType) {
        MatchType[MatchType["Platform"] = 0] = "Platform";
        MatchType[MatchType["Social"] = 1] = "Social";
    })(MatchType = MatchDefine.MatchType || (MatchDefine.MatchType = {}));
    let MatchMode;
    (function (MatchMode) {
        // 万科模式
        MatchMode[MatchMode["WanKe"] = 0] = "WanKe";
        // 周水子棋牌室模式
        MatchMode[MatchMode["ZhouShuiZi"] = 1] = "ZhouShuiZi";
        // 娱网循环赛模式
        MatchMode[MatchMode["YWCircle"] = 1000] = "YWCircle";
    })(MatchMode = MatchDefine.MatchMode || (MatchDefine.MatchMode = {}));
    let MatchGroupType;
    (function (MatchGroupType) {
        MatchGroupType[MatchGroupType["Mutex"] = 0] = "Mutex";
        MatchGroupType[MatchGroupType["Free"] = 1] = "Free";
        /**
         * 随机匹配
         */
        MatchGroupType[MatchGroupType["NormalRandom"] = 2] = "NormalRandom";
        /**
         * 档次匹配
         * values格式：[]
         */
        MatchGroupType[MatchGroupType["ModeGrade"] = 3] = "ModeGrade";
    })(MatchGroupType = MatchDefine.MatchGroupType || (MatchDefine.MatchGroupType = {}));
    let SignUpMode;
    (function (SignUpMode) {
        SignUpMode[SignUpMode["FlagMode"] = 65535] = "FlagMode";
        // 报名
        SignUpMode[SignUpMode["NoSignUp"] = 0] = "NoSignUp";
        SignUpMode[SignUpMode["Self"] = 1] = "Self";
        SignUpMode[SignUpMode["Admin"] = 2] = "Admin";
        SignUpMode[SignUpMode["Ex_BeforeStart"] = 65536] = "Ex_BeforeStart";
    })(SignUpMode = MatchDefine.SignUpMode || (MatchDefine.SignUpMode = {}));
    let MatchProperty;
    (function (MatchProperty) {
        MatchProperty[MatchProperty["IgnoreAd"] = 1] = "IgnoreAd";
    })(MatchProperty = MatchDefine.MatchProperty || (MatchDefine.MatchProperty = {}));
    let MatchStatus;
    (function (MatchStatus) {
        MatchStatus[MatchStatus["None"] = 0] = "None";
        MatchStatus[MatchStatus["Signup"] = 1] = "Signup";
        MatchStatus[MatchStatus["Wait"] = 2] = "Wait";
        MatchStatus[MatchStatus["Start"] = 3] = "Start";
        MatchStatus[MatchStatus["End"] = 4] = "End";
        MatchStatus[MatchStatus["RoundEnd"] = 5] = "RoundEnd";
    })(MatchStatus = MatchDefine.MatchStatus || (MatchDefine.MatchStatus = {}));
    function getMatchRankChangedName(matchID) {
        return "match-rank-" + matchID;
    }
    MatchDefine.getMatchRankChangedName = getMatchRankChangedName;
    /**
     * STD时间是相对于Valid时间的时间差
     * valid + step * interval 是当前循环的开始时间
     * valid + step * interval + STD 是STD的确切时间
     */
    let CircleTimeIndex;
    (function (CircleTimeIndex) {
        CircleTimeIndex[CircleTimeIndex["Valid"] = 0] = "Valid";
        CircleTimeIndex[CircleTimeIndex["STD_LoopStart"] = 1] = "STD_LoopStart";
        CircleTimeIndex[CircleTimeIndex["Interval"] = 2] = "Interval";
        CircleTimeIndex[CircleTimeIndex["STD_Sign"] = 3] = "STD_Sign";
        CircleTimeIndex[CircleTimeIndex["STD_Match"] = 4] = "STD_Match";
        // ...
        CircleTimeIndex[CircleTimeIndex["IndexEnd"] = 5] = "IndexEnd";
    })(CircleTimeIndex = MatchDefine.CircleTimeIndex || (MatchDefine.CircleTimeIndex = {}));
})(MatchDefine = exports.MatchDefine || (exports.MatchDefine = {}));
