"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const db_1 = require("./db");
const ServerConfig_1 = require("../../kds-base-define/src/ServerConfig");
const utils_1 = require("kdweb-core/lib/utils");
var BillUtils;
(function (BillUtils) {
    BillUtils.billTablename = "t_bill";
    BillUtils.fupanTablename = "t_fupan";
    BillUtils.simpleBillTablename = "t_simple_bill";
    BillUtils.exBillTablename = "t_bill_ex";
    function getDate(timestamp) {
        timestamp = timestamp == null ? utils_1.kdutils.getMillionSecond() : timestamp;
        return utils_1.kdutils.getFmtMoment("YYYY-MM-DD");
    }
    BillUtils.getDate = getDate;
    function today() {
        return getDate();
    }
    BillUtils.today = today;
    function getUserCacheTableName(timestamp) {
        return "t_user_cache_" + this.getDate(timestamp);
    }
    BillUtils.getUserCacheTableName = getUserCacheTableName;
    function getTeaCacheTableName(timestamp) {
        return "t_tea_cache_" + this.getDate(timestamp);
    }
    BillUtils.getTeaCacheTableName = getTeaCacheTableName;
    BillUtils.dbBill = db_1.DB.get(ServerConfig_1.ServerValues.dbBill);
    BillUtils.dbCache = db_1.DB.get(ServerConfig_1.ServerValues.dbBillCache);
})(BillUtils = exports.BillUtils || (exports.BillUtils = {}));
