"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const billUtils_1 = require("../billUtils");
const log_1 = require("../log");
const utils_1 = require("kdweb-core/lib/utils");
// 当天账单缓存超时时间
let todayCacheTimeout = 1 * 60 * 1000; // 1分钟
var BillCache;
(function (BillCache) {
    function getUserBill(userID, timestamp) {
        return __awaiter(this, void 0, void 0, function* () {
            let db = billUtils_1.BillUtils.dbCache;
            let todayDate = billUtils_1.BillUtils.getDate();
            let time = utils_1.kdutils.getMillionSecond();
            let date = billUtils_1.BillUtils.getDate(timestamp);
            let tableName = billUtils_1.BillUtils.getUserCacheTableName(timestamp);
            let results = yield db.get(tableName, { userID: userID }, 1);
            if (results == null) {
                log_1.Log.oth.error("[cache] getUserBill: db failed userID = " + userID);
                return [];
            }
            let newCache = true;
            if (results.length > 0) {
                let cache = results[0];
                if (date == todayDate) {
                    // 当天的站滚蛋要判断缓存超时
                    if (time - cache.prevTimestamp < todayCacheTimeout) {
                        return cache.bills;
                    }
                    newCache = false;
                }
                else {
                    let cacheDate = billUtils_1.BillUtils.getDate(cache.prevTimestamp);
                    // 当前缓存的时间如果不是账单当天的话就不需要再请求了
                    // 如果是账单当天的认为缓存超时
                    if (cacheDate != date) {
                        return cache.bills;
                    }
                    newCache = false;
                }
            }
            let bills = yield getUserBillInDB(userID, timestamp);
            // 数据库失败，无法建立缓存
            if (bills == null) {
                return [];
            }
            let cache = {
                userID: userID,
                bills: bills,
                prevTimestamp: utils_1.kdutils.getMillionSecond(),
            };
            if (newCache) {
                yield db.insert(tableName, cache);
            }
            else {
                yield db.update(tableName, { userID: userID }, cache);
            }
            return bills;
        });
    }
    BillCache.getUserBill = getUserBill;
    function getTeaBill(teaID, timestamp) {
        return __awaiter(this, void 0, void 0, function* () {
            let db = billUtils_1.BillUtils.dbCache;
            let todayDate = billUtils_1.BillUtils.getDate();
            let time = utils_1.kdutils.getMillionSecond();
            let date = billUtils_1.BillUtils.getDate(timestamp);
            let tableName = billUtils_1.BillUtils.getTeaCacheTableName(timestamp);
            let results = yield db.get(tableName, { teaID: teaID }, 1);
            if (results == null) {
                log_1.Log.oth.error("[cache] getTeaBill: db failed teaID = " + teaID);
                return [];
            }
            let newCache = true;
            if (results.length > 0) {
                let cache = results[0];
                if (date == todayDate) {
                    // 当天的数据要判断缓存超时
                    if (time - cache.prevTimestamp < todayCacheTimeout) {
                        return cache.bills;
                    }
                    newCache = false;
                }
                else {
                    let cacheDate = billUtils_1.BillUtils.getDate(cache.prevTimestamp);
                    // 当前缓存的时间如果不是账单当天的话就不需要再请求了
                    // 如果是账单当天的认为缓存超时
                    if (cacheDate != date) {
                        return cache.bills;
                    }
                    newCache = false;
                }
            }
            let bills = yield getTeaBillInDB(teaID, timestamp);
            // 数据库失败，无法建立缓存
            if (bills == null) {
                return [];
            }
            let cache = {
                teaID: teaID,
                bills: bills,
                prevTimestamp: utils_1.kdutils.getMillionSecond(),
            };
            if (newCache) {
                yield db.insert(tableName, cache);
            }
            else {
                yield db.update(tableName, { teaID: teaID }, cache);
            }
            return bills;
        });
    }
    BillCache.getTeaBill = getTeaBill;
    function getUserBillInDB(userID, timestamp) {
        return __awaiter(this, void 0, void 0, function* () {
            let tableName = billUtils_1.BillUtils.billTablename;
            let date = billUtils_1.BillUtils.getDate(timestamp);
            let results = yield billUtils_1.BillUtils.dbBill.get(tableName, { startDate: date, users: { $elemMatch: { userID: userID } } });
            if (results == null) {
                log_1.Log.oth.error("[cache] getUserBillInDB: db failed userID = " + userID);
                return null;
            }
            return results;
        });
    }
    function getTeaBillInDB(teaID, timestamp) {
        return __awaiter(this, void 0, void 0, function* () {
            let tableName = billUtils_1.BillUtils.simpleBillTablename;
            let date = billUtils_1.BillUtils.getDate(timestamp);
            let results = yield billUtils_1.BillUtils.dbBill.get(tableName, { startDate: date, "roomPOData.roomData.teaExt.teaID": teaID });
            if (results == null) {
                log_1.Log.oth.error("[cache] getTeaBillInDB: db failed teaID = " + teaID);
                return null;
            }
            return results;
        });
    }
})(BillCache = exports.BillCache || (exports.BillCache = {}));
