"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
const protocols_1 = require("kdweb-core/lib/rpc/protocols");
const utils_1 = require("kdweb-core/lib/utils");
const billUtils_1 = require("../billUtils");
const billCache_1 = require("./billCache");
const log_1 = require("../log");
const zlib_1 = require("zlib");
var BillHelper;
(function (BillHelper) {
    function getBillID() {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.call("kds.ids.getId", "bill-service", 10000000, 1);
            if (ret.code == protocols_1.kdRpcMsg.CallErrorCode.Success) {
                return ret.data;
            }
            log_1.Log.oth.error("cannot create new bill id ", ret.error);
            return -1;
        });
    }
    function getFupanID() {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.call("kds.ids.getId", "fupan-service", 100000, 1);
            if (ret.code == protocols_1.kdRpcMsg.CallErrorCode.Success) {
                return ret.data;
            }
            log_1.Log.oth.error("cannot create new fupan id ", ret.error);
            return -1;
        });
    }
    function createFupan(billID, fupanMsgs) {
        return __awaiter(this, void 0, void 0, function* () {
            if (fupanMsgs == null || fupanMsgs.length == 0) {
                return null;
            }
            let fupanID = yield getFupanID();
            if (fupanID < 0) {
                return null;
            }
            let str = JSON.stringify(fupanMsgs);
            let data = zlib_1.gzipSync(str).toString("base64");
            let fupan = {
                billID: billID,
                fupanID: fupanID,
                timestamp: utils_1.kdutils.getMillionSecond(),
                date: utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss"),
                data: data,
            };
            yield billUtils_1.BillUtils.dbBill.insert(billUtils_1.BillUtils.fupanTablename, fupan);
            return fupanID;
        });
    }
    BillHelper.createFupan = createFupan;
    function report(bill, fupanMsgs) {
        return __awaiter(this, void 0, void 0, function* () {
            bill.billID = yield getBillID();
            if (bill.billID < 0) {
                bill.billID = utils_1.kdutils.getMillionSecond();
            }
            if (fupanMsgs && fupanMsgs.length > 0) {
                bill.fupanID = yield createFupan(bill.billID, fupanMsgs);
            }
            bill.startDate = billUtils_1.BillUtils.getDate(bill.startTimestamp);
            let roomPOData = bill.roomPOData;
            let roomData = roomPOData.roomData;
            if (roomData.teaExt && roomData.teaExt.teaID) {
                // ???茶馆需不需要单独处理
            }
            bill["roomID"] = roomPOData.roomID;
            let count = yield billUtils_1.BillUtils.dbBill.insert(billUtils_1.BillUtils.billTablename, bill);
            return count > 0;
        });
    }
    BillHelper.report = report;
    function reportEx(bill) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!bill.teaID) {
                return false;
            }
            let teaMember = yield rpc_1.Rpc.center.callException("kds.dbp.tea.get.simpleMember", bill.teaID);
            if (teaMember == null) {
                return false;
            }
            let leader = teaMember.leaderRelations.find(v => v.userID == bill.userID);
            if (leader) {
                bill.leaderUserID = leader.userID;
            }
            else {
                bill.leaderUserID = null;
            }
            let time = utils_1.kdutils.getMillionSecond();
            bill.timestamp = time;
            bill.date = utils_1.kdutils.getFmtMoment("YYYY-MM-DD");
            bill.fullDate = utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss");
            let count = yield billUtils_1.BillUtils.dbBill.insert(billUtils_1.BillUtils.exBillTablename, bill);
            return count > 0;
        });
    }
    BillHelper.reportEx = reportEx;
    function _reportSimple(bill) {
        return __awaiter(this, void 0, void 0, function* () {
            if (bill.roomPOData.roomData.teaExt == null) {
                return false;
            }
            // bill.billID = await getBillID()
            // if(bill.billID < 0) {
            // 	bill.billID = kdutils.getMillionSecond()
            // }
            if (bill.users) {
                for (let user of bill.users) {
                    delete user.iconUrl;
                    delete user.nickName;
                }
            }
            let count = yield billUtils_1.BillUtils.dbBill.insert(billUtils_1.BillUtils.simpleBillTablename, bill);
            return count > 0;
        });
    }
    function getUserBill(userID, startTimestamp, days) {
        return __awaiter(this, void 0, void 0, function* () {
            days = days || 1;
            if (days <= 0) {
                return [];
            }
            startTimestamp = startTimestamp || utils_1.kdutils.getMillionSecond();
            let ret = [];
            for (let i = 0; i < days; i++) {
                let time = startTimestamp - (i * 24 * 60 * 60 * 1000);
                let bills = yield billCache_1.BillCache.getUserBill(userID, time);
                ret.push.apply(ret, bills);
            }
            // 由近及远排序
            ret.sort((l, r) => r.startTimestamp - l.startTimestamp);
            return ret;
        });
    }
    BillHelper.getUserBill = getUserBill;
    function getTeaBill(teaID, startTimestamp, days) {
        return __awaiter(this, void 0, void 0, function* () {
            days = days || 1;
            if (days <= 0) {
                return [];
            }
            startTimestamp = startTimestamp || utils_1.kdutils.getMillionSecond();
            let ret = [];
            for (let i = 0; i < days; i++) {
                let time = startTimestamp - (i * 24 * 60 * 60 * 1000);
                let bills = yield billCache_1.BillCache.getTeaBill(teaID, time);
                ret.push.apply(ret, bills);
            }
            // 由近及远排序
            ret.sort((l, r) => r.startTimestamp - l.startTimestamp);
            return ret;
        });
    }
    BillHelper.getTeaBill = getTeaBill;
    function getRoomBills(roomID) {
        return __awaiter(this, void 0, void 0, function* () {
            let bills = yield billUtils_1.BillUtils.dbBill.get(billUtils_1.BillUtils.billTablename, { roomID: roomID });
            return bills;
        });
    }
    BillHelper.getRoomBills = getRoomBills;
    function getFupanData(fupanID) {
        return __awaiter(this, void 0, void 0, function* () {
            let fupan = yield billUtils_1.BillUtils.dbBill.getSingle(billUtils_1.BillUtils.fupanTablename, { fupanID: fupanID });
            return fupan ? fupan.data : null;
        });
    }
    BillHelper.getFupanData = getFupanData;
})(BillHelper = exports.BillHelper || (exports.BillHelper = {}));
