"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const centerClient_1 = require("kdweb-core/lib/rpc/center/centerClient");
const ServerConfig_1 = require("../../kds-base-define/src/ServerConfig");
const config_1 = require("./config");
const bill_1 = require("./rpc/bill");
const billCursor_1 = require("./rpc/billCursor");
const daily_1 = require("./rpc/daily");
var Rpc;
(function (Rpc) {
    function init() {
        if (ServerConfig_1.ServerValues.localIp) {
            centerClient_1.kdRpcCenterClient.setupLocalHostReplacement(ServerConfig_1.ServerValues.localIp);
        }
        Rpc.center = new centerClient_1.kdRpcCenterClient.entity({
            centerHost: ServerConfig_1.ServerValues.rpcCenterHost,
            port: config_1.Config.myConfig.wsPort,
            token: ServerConfig_1.ServerValues.rpcToken,
            info: {
                name: config_1.Config.myName,
                tag: config_1.Config.myName,
                host: config_1.Config.myConfig.wsHost,
                auth: "Vash",
                version: "1.0",
                timestamp: 0,
                data: null
            }
        });
        Rpc.center.logUrlPath = ServerConfig_1.ServerValues.rpcLoggerHost;
        Rpc.center.addGroup("kds.bill.user", bill_1.RpcUserBillService);
        Rpc.center.addGroup("kds.bill.tea", bill_1.RpcTeaBillService);
        Rpc.center.addGroup("kds.bill.fupan", bill_1.RpcFupanService);
        Rpc.center.addGroup("kds.bill.room", bill_1.RpcRoomService);
        Rpc.center.addGroup("kds.bill.daily", daily_1.RpcDaily);
        Rpc.center.addGroup("kds.bill.cursor.user", billCursor_1.RpcCursorUserBillService);
        Rpc.center.addGroup("kds.bill.cursor.tea", billCursor_1.RpcCursorTeaBillService);
    }
    Rpc.init = init;
})(Rpc = exports.Rpc || (exports.Rpc = {}));
