"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const TeaFundBillLooper_1 = require("../../../kds-bill-report/src/looper/TeaFundBillLooper");
const TeaUserBillLooper_1 = require("../../../kds-bill-report/src/looper/TeaUserBillLooper");
function getTeaUserBill(h, teaID, lastCount) {
    return __awaiter(this, void 0, void 0, function* () {
        let ret = yield TeaUserBillLooper_1.TeaUserBillLooper.getPrevDateBill(teaID, lastCount);
        return ret;
    });
}
function getTeaFundBill(h, teaID, lastCount) {
    return __awaiter(this, void 0, void 0, function* () {
        let ret = yield TeaFundBillLooper_1.TeaFundBillLooper.getPrevDateBill(teaID, lastCount);
        return ret;
    });
}
function getTeaFundUserBill(h, teaID, userID, lastCount) {
    return __awaiter(this, void 0, void 0, function* () {
        let ret = yield TeaFundBillLooper_1.TeaFundBillLooper.getPrevDateBill(teaID, lastCount);
        if (ret) {
            let item = ret.items.find(v => v.userID == userID);
            return item;
        }
        return null;
    });
}
exports.RpcDaily = {
    teaUser: getTeaUserBill,
    teaFund: getTeaFundBill,
    teaFundUser: getTeaFundUserBill,
};
