"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const centerClient_1 = require("kdweb-core/lib/rpc/center/centerClient");
const ServerConfig_1 = require("../../kds-base-define/src/ServerConfig");
const config_1 = require("./config");
const user_1 = require("./rpc/user");
const room_1 = require("./rpc/room");
const tea_1 = require("./rpc/tea");
const tea_user_1 = require("./rpc/tea_user");
const task_1 = require("./rpc/task");
const prop_1 = require("./rpc/prop");
var Rpc;
(function (Rpc) {
    function init() {
        if (ServerConfig_1.ServerValues.localIp) {
            centerClient_1.kdRpcCenterClient.setupLocalHostReplacement(ServerConfig_1.ServerValues.localIp);
        }
        Rpc.center = new centerClient_1.kdRpcCenterClient.entity({
            centerHost: ServerConfig_1.ServerValues.rpcCenterHost,
            port: config_1.Config.myConfig.wsPort,
            token: ServerConfig_1.ServerValues.rpcToken,
            info: {
                name: config_1.Config.myName,
                tag: config_1.Config.myName,
                host: config_1.Config.myConfig.wsHost,
                auth: "Vash",
                version: "1.0",
                timestamp: 0,
                data: null
            }
        });
        Rpc.center.logUrlPath = ServerConfig_1.ServerValues.rpcLoggerHost;
        Rpc.center.addGroup("kds.inpay.user", user_1.RpcUser);
        Rpc.center.addGroup("kds.inpay.task", task_1.RpcTask);
        Rpc.center.addGroup("kds.inpay.room", room_1.RpcRoom);
        Rpc.center.addGroup("kds.inpay.tea", tea_1.RpcTea);
        Rpc.center.addGroup("kds.inpay.prop", prop_1.RpcProp);
        Rpc.center.addGroup("kds.inpay.tea.useraccount", tea_user_1.RpcTeaUserAccount);
    }
    Rpc.init = init;
})(Rpc = exports.Rpc || (exports.Rpc = {}));
