"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
const log_1 = require("../log");
const utils_1 = require("kdweb-core/lib/utils");
const task_1 = require("./task");
function mailPropChange(h, userID, sk, attaData) {
    return __awaiter(this, void 0, void 0, function* () {
        if (attaData.length < 1) {
            return false;
        }
        let call = yield rpc_1.Rpc.center.call("kds.dbp.user.bag.get", userID);
        if (call.code != 0) {
            return false;
        }
        let attaList = [];
        for (let i = 0; i < attaData.length; i++) {
            if (attaData[i].attaID === 200000) {
                yield task_1.RpcTask.monthlyCards(userID, sk, attaData[i].attaNumber);
            }
            else {
                attaList.push(attaData[i]);
            }
        }
        let updatedBag = yield addEmote(userID, sk, attaList, call.data);
        log_1.Log.oth.info('[propChange] updatedBag >', updatedBag);
        yield rpc_1.Rpc.center.call("kds.dbp.user.bag.set", userID, updatedBag);
        return true;
    });
}
function awardPropChange(h, userID, sk, parpData) {
    return __awaiter(this, void 0, void 0, function* () {
        if (parpData.length < 1) {
            return false;
        }
        let call = yield rpc_1.Rpc.center.call("kds.dbp.user.bag.get", userID);
        if (call.code != 0) {
            return false;
        }
        let bag = call.data;
        let propList = yield rpc_1.Rpc.center.callException("kds.dbp.store.getAllByRedis", 2);
        if (!bag) {
            bag = yield getPackData(userID);
        }
        for (let i = 0; i < parpData.length; i++) {
            let prop = propList.find(msg => msg.moneyID === parpData[i].propID);
            if (prop) {
                bag.goods = addProp(bag.goods, prop, parpData[i].count);
            }
        }
        yield rpc_1.Rpc.center.call("kds.dbp.user.bag.set", userID, bag);
        return true;
    });
}
function addEmote(userID, sk, attaData, bag) {
    return __awaiter(this, void 0, void 0, function* () {
        let propList = yield rpc_1.Rpc.center.callException("kds.dbp.store.getAllByRedis", 2);
        if (!bag) {
            bag = yield getPackData(userID);
        }
        for (let i = 0; i < attaData.length; i++) {
            let prop = propList.find(msg => msg.moneyID === attaData[i].attaID);
            if (prop) {
                bag.goods = addProp(bag.goods, prop, attaData[i].attaNumber);
            }
        }
        return bag;
    });
}
function getGoodsData(name, goodsID, count, type, profile = '', validTime = 0) {
    return {
        goodsID: goodsID,
        name: name,
        count: count,
        isUse: false,
        create_timestamp: utils_1.kdutils.getMillionSecond(),
        update_timestamp: utils_1.kdutils.getMillionSecond(),
        profile: profile,
        validTime: validTime,
        type: type,
    };
}
function getPackData(userID) {
    return {
        userID: userID,
        goods: []
    };
}
function addProp(goods, prop, count) {
    let reg = goods.find(msg => msg.goodsID == prop.moneyID);
    if (!reg) {
        let goodsData = getGoodsData(prop.name, prop.moneyID, count, prop.type, prop.desc);
        goods.push(goodsData);
    }
    else {
        reg.count += count;
        log_1.Log.oth.info('[addProp] reg.count >', reg.count, ' count >', count);
    }
    log_1.Log.oth.info('[addProp] goods >', goods);
    return goods;
}
exports.RpcProp = {
    mailAdd: mailPropChange,
    awardAdd: awardPropChange
};
