"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
const log_1 = require("../log");
const UserDefine_1 = require("../../../kds-base-define/src/UserDefine");
const utils_1 = require("kdweb-core/lib/utils");
const tools_1 = require("../helper/tools");
function monthlyCards(userID, sk, date) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!utils_1.kdutils.isValid(userID, "number") || !utils_1.kdutils.isValid(sk, "string")) {
            return false;
        }
        let b = yield tools_1.tools.mutexFunc(userID, function () {
            return __awaiter(this, void 0, void 0, function* () {
                let ret = yield rpc_1.Rpc.center.call("kds.dbp.task.monthlycard.get", { sk: sk });
                if (ret.code != 0) {
                    return false;
                }
                let userTaskInfo = ret.data;
                let time = utils_1.kdutils.getMillionSecond();
                let timeStr = utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss");
                const days = date;
                const millisecondsInADay = 24 * 60 * 60 * 1000;
                if (userTaskInfo == null) {
                    let data = {
                        createTime: time,
                        endTime: time + days * millisecondsInADay,
                        buyTime: timeStr,
                        userID: userID,
                        prop: [{ propID: 200000, startTime: time, endTime: time + days * millisecondsInADay }],
                        sk: sk,
                        taskID: UserDefine_1.UserDefine.TaskType.monthlyCards,
                        lastGet: 0,
                        buyCount: 1
                    };
                    yield rpc_1.Rpc.center.call("kds.dbp.task.monthlycard.set", data);
                }
                else {
                    if (time < userTaskInfo.endTime) {
                        userTaskInfo.endTime += days * millisecondsInADay;
                    }
                    else {
                        userTaskInfo.endTime = time + days * millisecondsInADay;
                    }
                    if (time < userTaskInfo.prop.find((msg) => msg.propID == 200000).endTime) {
                        userTaskInfo.prop.find((msg) => msg.propID == 200000).endTime += days * millisecondsInADay;
                    }
                    else {
                        userTaskInfo.prop.find((msg) => msg.propID == 200000).endTime = time + days * millisecondsInADay;
                    }
                    userTaskInfo.buyTime = timeStr;
                    userTaskInfo.buyCount++;
                    yield rpc_1.Rpc.center.call("kds.dbp.task.monthlycard.update", userTaskInfo);
                }
                // let userData = await Rpc.center.call("kds.dbp.user.userInfo.get", sk)
                // let userInfo = <UserDefine.UserInfoData>userData.data
                // let oldCount = userInfo.goldCount
                // userInfo.goldCount += 50000
                // if (Number.isNaN(userInfo.goldCount)) {
                //     Log.oth.error("gold count change failed changeCount = ", userInfo)
                //     userInfo.goldCount = oldCount
                //     return false
                // }
                // await Rpc.center.call("kds.dbp.user.userInfo.update", userInfo)
                // Rpc.center.call("kds.nt.changed.user.userInfo", userID, userInfo)
                // let msg = {
                // 	getRewardTime: time,
                // 	userID: userID,
                // 	sk: sk,
                // 	timeStr: timeStr,
                // }
                // await Rpc.center.callException("kds.dbp.task.monthlycard.setLog", msg);
                return true;
            });
        });
        return b;
    });
}
function noble(userID, changeCount, zeroEnabled) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!utils_1.kdutils.isValid(userID, "number") || !utils_1.kdutils.isValid(changeCount, "number")) {
            return false;
        }
        let b = yield tools_1.tools.mutexFunc(userID, function () {
            return __awaiter(this, void 0, void 0, function* () {
                let ret = yield rpc_1.Rpc.center.call("kds.dbp.user.userInfo.get", userID);
                if (ret.code != 0) {
                    return false;
                }
                let userInfo = ret.data;
                if (userInfo == null) {
                    return false;
                }
                let oldCount = userInfo.diamondCount;
                userInfo.diamondCount += changeCount;
                if (userInfo.diamondCount < 0) {
                    if (zeroEnabled) {
                        userInfo.diamondCount = 0;
                    }
                    else {
                        return false;
                    }
                }
                if (Number.isNaN(userInfo.diamondCount)) {
                    log_1.Log.oth.error("diamond count change failed changeCount = " + changeCount, userInfo);
                    userInfo.diamondCount = oldCount;
                    return false;
                }
                yield rpc_1.Rpc.center.call("kds.dbp.user.userInfo.update", userInfo);
                rpc_1.Rpc.center.call("kds.nt.changed.user.userInfo", userID, userInfo);
                return true;
            });
        });
        return b;
    });
}
exports.RpcTask = {
    monthlyCards: monthlyCards,
    noble: noble,
};
