"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var UserDefine;
(function (UserDefine) {
    let LoginDeviceType;
    (function (LoginDeviceType) {
        LoginDeviceType[LoginDeviceType["Win32"] = 0] = "Win32";
        LoginDeviceType[LoginDeviceType["iOS"] = 1] = "iOS";
        LoginDeviceType[LoginDeviceType["Android"] = 2] = "Android";
        // 普通H5
        LoginDeviceType[LoginDeviceType["H5"] = 3] = "H5";
        // 微信小游戏
        LoginDeviceType[LoginDeviceType["WechatMiniGame"] = 4] = "WechatMiniGame";
        // 微信公众号
        LoginDeviceType[LoginDeviceType["WechatOfficial"] = 5] = "WechatOfficial";
    })(LoginDeviceType = UserDefine.LoginDeviceType || (UserDefine.LoginDeviceType = {}));
    let AccountType;
    (function (AccountType) {
        AccountType[AccountType["Guest"] = 0] = "Guest";
        AccountType[AccountType["Wechat"] = 1] = "Wechat";
        AccountType[AccountType["Account"] = 2] = "Account";
        AccountType[AccountType["Robot"] = 100] = "Robot";
    })(AccountType = UserDefine.AccountType || (UserDefine.AccountType = {}));
    let platformType;
    (function (platformType) {
        platformType[platformType["Test"] = 0] = "Test";
        platformType[platformType["H5"] = 1] = "H5";
        platformType[platformType["WechatGame"] = 2] = "WechatGame";
        platformType[platformType["WechatOfficial"] = 3] = "WechatOfficial";
        platformType[platformType["XiaoMiGame"] = 4] = "XiaoMiGame";
        platformType[platformType["HuaWeiGame"] = 5] = "HuaWeiGame";
        platformType[platformType["OppoGame"] = 6] = "OppoGame";
        platformType[platformType["VivoGame"] = 7] = "VivoGame";
    })(platformType = UserDefine.platformType || (UserDefine.platformType = {}));
    let GameID;
    (function (GameID) {
        GameID[GameID["WECHATGAME_DGZ"] = 400001] = "WECHATGAME_DGZ";
        GameID[GameID["WECHATGAME_TDH"] = 400002] = "WECHATGAME_TDH";
    })(GameID = UserDefine.GameID || (UserDefine.GameID = {}));
    UserDefine.CustomGameRecordGroupID = 99;
    let TaskType;
    (function (TaskType) {
        TaskType[TaskType["monthlyCards"] = 310001] = "monthlyCards";
        TaskType[TaskType["noble"] = 310002] = "noble";
    })(TaskType = UserDefine.TaskType || (UserDefine.TaskType = {}));
    UserDefine.nickNameMinLen = 2;
    UserDefine.nickNameMaxLen = 10;
    function getUserSideLoginData(loginData) {
        if (loginData == null) {
            return loginData;
        }
        if (loginData.pwdMd5) {
            delete loginData.pwdMd5;
        }
        if (loginData.regTimestamp) {
            delete loginData.regTimestamp;
        }
        if (loginData.regDate) {
            delete loginData.regDate;
        }
        return loginData;
    }
    UserDefine.getUserSideLoginData = getUserSideLoginData;
})(UserDefine = exports.UserDefine || (exports.UserDefine = {}));
