"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const RoomDefine_1 = require("../../../kds-base-define/src/RoomDefine");
const user_1 = require("../rpc/user");
const rpc_1 = require("../rpc");
var RoomPayHelper;
(function (RoomPayHelper) {
    function coinGameEnd(roomPOData, roomRealtime, bill) {
        return __awaiter(this, void 0, void 0, function* () {
            yield rpc_1.Rpc.center.callException("kds.group.room.end", roomPOData, roomRealtime, bill);
            let roomData = roomPOData.roomData;
            let payUse = RoomDefine_1.RoomDefine.getPayUse(roomData.roomExt.payType);
            if (payUse == RoomDefine_1.RoomDefine.PayType.UseGroup) {
                return true;
            }
            for (let info of bill.scores) {
                let score = info.score;
                yield user_1.RpcUser.gold(null, info.userID, info.score, true);
            }
            return true;
        });
    }
    RoomPayHelper.coinGameEnd = coinGameEnd;
    function matchGameEnd(roomPOData, roomRealtime, bill) {
        return __awaiter(this, void 0, void 0, function* () {
            yield rpc_1.Rpc.center.callException("kds.group.room.end", roomPOData, roomRealtime, bill);
        });
    }
    RoomPayHelper.matchGameEnd = matchGameEnd;
})(RoomPayHelper = exports.RoomPayHelper || (exports.RoomPayHelper = {}));
