"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const MutexDefine_1 = require("../../../kds-base-define/src/MutexDefine");
const log_1 = require("../log");
const rpc_1 = require("../rpc");
var tools;
(function (tools) {
    function mutexFunc(userID, func) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                let b = yield rpc_1.Rpc.center.callException("kds.mutex.get", MutexDefine_1.MutexDefine.UserInfo(userID), 10000);
                if (!b) {
                    log_1.Log.oth.info("get mutex failed userID = " + userID);
                    return false;
                }
                b = yield func();
                return b;
            }
            catch (error) {
                log_1.Log.oth.error("get mutex failed userID = " + userID + " error = ", error);
            }
            finally {
                yield rpc_1.Rpc.center.call("kds.mutex.release", MutexDefine_1.MutexDefine.UserInfo(userID));
            }
            return false;
        });
    }
    tools.mutexFunc = mutexFunc;
})(tools = exports.tools || (exports.tools = {}));
