"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const RoomDefine_1 = require("../../../kds-base-define/src/RoomDefine");
const GameSet_1 = require("../../../kds-base-define/src/GameSet");
const user_1 = require("./user");
const roomPayHelper_1 = require("../helper/roomPayHelper");
const tea_1 = require("./tea");
const teaHelper_1 = require("../helper/teaHelper");
// 计费，扣卡，扣钻
function roomCreate(h, roomPOData) {
    return __awaiter(this, void 0, void 0, function* () {
        let roomData = roomPOData.roomData;
        if (roomData.teaExt) {
            return yield teaHelper_1.TeaHelper.roomCreate(roomPOData);
        }
        let gameData = roomData.gameData;
        let gameSet = new GameSet_1.GameSet(gameData.gameID, gameData.bSets, gameData.iSets);
        let price = gameSet.getSpendMoney();
        if (roomPOData.roomData.teaExt) {
            let b = yield tea_1.RpcTea.card(h, roomPOData.roomData.teaExt.teaID, -price);
            return b;
        }
        let payTarget = RoomDefine_1.RoomDefine.getPayTarget(roomData.roomExt.payType);
        let payUse = RoomDefine_1.RoomDefine.getPayUse(roomData.roomExt.payType);
        if (payTarget == 0 || payUse == 0) {
            return true;
        }
        if (payTarget == RoomDefine_1.RoomDefine.PayType.CoinGame) {
            return true;
        }
        let b = true;
        switch (payTarget) {
            case RoomDefine_1.RoomDefine.PayType.Boss:
                {
                    b = yield user_1.RpcUser.card(h, roomPOData.roomData.bossUserID, -price);
                }
                break;
            case RoomDefine_1.RoomDefine.PayType.AA:
                {
                    //payUserIDs.set(roomPOData.roomData.bossUserID,price)
                }
                break;
            case RoomDefine_1.RoomDefine.PayType.Winner:
                {
                    //payUserIDs.set(roomPOData.roomData.bossUserID,price)
                }
                break;
        }
        // let payUserIDs = new Map<number,number>()
        // switch(payTarget) {
        // 	case RoomDefine.PayType.Boss: {
        // 		payUserIDs.set(roomPOData.roomData.bossUserID,price)
        // 	} break 
        // 	case RoomDefine.PayType.AA: {
        // 		//payUserIDs.set(roomPOData.roomData.bossUserID,price)
        // 	} break 
        // 	case RoomDefine.PayType.Winner: {
        // 		//payUserIDs.set(roomPOData.roomData.bossUserID,price)
        // 	} break 
        // }
        // Log.oth.info("[room] payTarget = " + RoomDefine.PayType[payTarget] + " payUse = " + RoomDefine.PayType[payUse])
        // Log.oth.info("[room] create pay dict ",payUserIDs)
        // let b = false 
        // switch(payUse) {
        // 	case RoomDefine.PayType.UseCard: {
        // 		payUserIDs.forEach(async function(value,userID) {
        // 			RpcUser.card(h,userID,-value)
        // 		})
        // 	} break 
        // 	case RoomDefine.PayType.UseDiamond: {
        // 		payUserIDs.forEach(async function(value,userID) {
        // 			RpcUser.diamond(h,userID,-value)
        // 		})
        // 	} break 
        // 	case RoomDefine.PayType.UseGold: {
        // 		payUserIDs.forEach(async function(value,userID) {
        // 			RpcUser.gold(h,userID,-value)
        // 		})
        // 	} break 
        // }
        // b = true 
        return b;
    });
}
function roomEnd(h, roomPOData, roomRealtime, bill) {
    return __awaiter(this, void 0, void 0, function* () {
        let roomData = roomPOData.roomData;
        if (roomData.teaExt) {
            return yield teaHelper_1.TeaHelper.roomEnd(roomPOData, roomRealtime, bill);
        }
        let gameData = roomData.gameData;
        let gameSet = new GameSet_1.GameSet(gameData.gameID, gameData.bSets, gameData.iSets);
        let price = gameSet.getSpendMoney();
        let payTarget = RoomDefine_1.RoomDefine.getPayTarget(roomData.roomExt.payType);
        let payUse = RoomDefine_1.RoomDefine.getPayUse(roomData.roomExt.payType);
        if (payTarget == 0 || payUse == 0) {
            return true;
        }
        if (payTarget == RoomDefine_1.RoomDefine.PayType.CoinGame) {
            return yield roomPayHelper_1.RoomPayHelper.coinGameEnd(roomPOData, roomRealtime, bill);
        }
        if (payTarget == RoomDefine_1.RoomDefine.PayType.MatchGame) {
            return yield roomPayHelper_1.RoomPayHelper.matchGameEnd(roomPOData, roomRealtime, bill);
        }
        let playingUsers = [];
        for (let user of roomRealtime.userInfos) {
            if (user.chairNo < RoomDefine_1.RoomDefine.watchChairNoStart) {
                playingUsers.push(user);
            }
        }
        // 房卡返还
        if (bill == null) {
            let b = true;
            switch (payUse) {
                case RoomDefine_1.RoomDefine.PayType.UseCard:
                    {
                        b = yield user_1.RpcUser.card(h, roomPOData.roomData.bossUserID, price);
                    }
                    break;
                case RoomDefine_1.RoomDefine.PayType.UseDiamond:
                    {
                        b = yield user_1.RpcUser.diamond(h, roomPOData.roomData.bossUserID, price);
                    }
                    break;
                case RoomDefine_1.RoomDefine.PayType.UseGold:
                    {
                        b = yield user_1.RpcUser.gold(h, roomPOData.roomData.bossUserID, price);
                    }
                    break;
            }
            return b;
        }
        if (roomPOData.roomData.teaExt) {
            if (roomRealtime.status <= RoomDefine_1.RoomDefine.RoomStatusType.Wait) {
                // 房卡返还
            }
            else {
                // 大赢家支付：查账单
            }
        }
        else {
            if (roomRealtime.status <= RoomDefine_1.RoomDefine.RoomStatusType.Wait) {
                let b = yield user_1.RpcUser.card(h, roomPOData.roomData.bossUserID, price);
                // 房卡返还
            }
            else {
                // 大赢家支付：查账单
            }
        }
        return true;
    });
}
function deProp(h, propCost) {
    return __awaiter(this, void 0, void 0, function* () {
        for (let info of propCost) {
            if (info.count == 0)
                continue;
            let score = -info.count;
            yield user_1.RpcUser.gold(null, info.userID, score, true);
        }
    });
}
exports.RpcRoom = {
    create: roomCreate,
    end: roomEnd,
    deProp: deProp
};
