"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
const MutexDefine_1 = require("../../../kds-base-define/src/MutexDefine");
const log_1 = require("../log");
const utils_1 = require("kdweb-core/lib/utils");
function mutexFunc(teaID, func) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            let b = yield rpc_1.Rpc.center.callException("kds.mutex.get", MutexDefine_1.MutexDefine.TeaData(teaID), 10000);
            if (!b) {
                log_1.Log.oth.info("get mutex failed teaID = " + teaID);
                return false;
            }
            b = yield func();
            return b;
        }
        catch (error) {
            log_1.Log.oth.error("get mutex failed teaID = " + teaID + " error = ", error);
        }
        finally {
            yield rpc_1.Rpc.center.call("kds.mutex.release", MutexDefine_1.MutexDefine.TeaData(teaID));
        }
        return false;
    });
}
function cardChange(h, teaID, changeCount) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!utils_1.kdutils.isValid(teaID, "number") || !utils_1.kdutils.isValid(changeCount, "number")) {
            return false;
        }
        let b = yield mutexFunc(teaID, function () {
            return __awaiter(this, void 0, void 0, function* () {
                let ret = yield rpc_1.Rpc.center.call("kds.dbp.tea.get.data", teaID);
                if (ret.code != 0) {
                    return false;
                }
                let teaData = ret.data;
                if (teaData == null) {
                    return false;
                }
                let oldCount = teaData.cardCount;
                teaData.cardCount += changeCount;
                if (teaData.cardCount < 0) {
                    return false;
                }
                if (Number.isNaN(teaData.cardCount)) {
                    log_1.Log.oth.error("card count change failed changeCount = " + changeCount, teaData);
                    teaData.cardCount = oldCount;
                    return false;
                }
                yield rpc_1.Rpc.center.callException("kds.dbp.tea.update.data", teaData);
                return true;
            });
        });
        if (b) {
            rpc_1.Rpc.center.callException("kds.tea.notify.teaDataChanged", teaID);
        }
        return b;
    });
}
exports.RpcTea = {
    card: cardChange
};
