"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var SrsInternal;
(function (SrsInternal) {
    function getGSApiPrefix(tag) {
        return "kds.srs-in.gs." + tag;
    }
    SrsInternal.getGSApiPrefix = getGSApiPrefix;
    function getGSApiCommonPrefix() {
        return "kds.srs-in.gs";
    }
    SrsInternal.getGSApiCommonPrefix = getGSApiCommonPrefix;
    function getSrsNodeApiPrefix(name) {
        return "kds.srs-in.ns." + name;
    }
    SrsInternal.getSrsNodeApiPrefix = getSrsNodeApiPrefix;
    function getRobotApiCommonPrefix() {
        return "kds.srs-in.robot";
    }
    SrsInternal.getRobotApiCommonPrefix = getRobotApiCommonPrefix;
    function getSrsNodeRobotApiCommonPrefix() {
        return "kds.srs-in.noderobotside";
    }
    SrsInternal.getSrsNodeRobotApiCommonPrefix = getSrsNodeRobotApiCommonPrefix;
    // node 访问 center 的接口
    let CenterSide;
    (function (CenterSide) {
        CenterSide.getAllNodes = "kds.srs-in.centerside.getAllNodes";
        CenterSide.getAllNodeOtherConfigs = "kds.srs-in.centerside.getAllNodeOtherConfigs";
        CenterSide.userReg = "kds.srs-in.centerside.userReg";
        CenterSide.userUnReg = "kds.srs-in.centerside.userUnReg";
    })(CenterSide = SrsInternal.CenterSide || (SrsInternal.CenterSide = {}));
    // center 或其他服务访问 node 的通用负载均衡接口
    let NodeSide;
    (function (NodeSide) {
        /**
         * @method 	getUserCount
         * @param
         * @returns number
         */
        NodeSide.getUserCount = "kds.srs-in.nodeside.getUserCount";
        /**
         * @method 	getNodeUserInfos
         * @param
         * @returns UserNodeConnectionInfo[]
         */
        NodeSide.getNodeUserInfos = "kds.srs-in.nodeside.getNodeUserInfos";
        /**
         * @method 	findUser
         * @param 	[userID:number]
         * @returns boolean
         */
        NodeSide.findUser = "kds.srs-in.nodeside.findUser";
        /**
         * @method 	sendToUser
         * @param 	[userID:number,msgName:string,jsonObj]
         * @returns boolean
         */
        NodeSide.sendToUser = "kds.srs-in.nodeside.sendToUser";
        /**
         * @method 	roomCount
         * @param
         * @returns number
         */
        NodeSide.roomCount = "kds.srs-in.nodeside.getRoomCount";
        /**
         * @method 	checkRoom
         * @param 	[codeOrID:string | number]
         * @returns gsName
         */
        NodeSide.checkRoom = "kds.srs-in.nodeside.checkRoom";
        /**
         * @method 	clearInvalidRooms
         * @param
         * @returns boolean
         */
        NodeSide.clearInvalidRooms = "kds.srs-in.nodeside.clearInvalidRooms";
        /**
         * @method 	jiesanRoom
         * @param 	[codeOrID:string | number]
         * @returns boolean
         */
        NodeSide.jiesanRoom = "kds.srs-in.nodeside.jiesanRoom";
        /**
         * @method 	verifyRoom
         * @param	[gameData]
         * @returns boolean
         */
        NodeSide.verifyRoom = "kds.srs-in.nodeside.verifyRoom";
        /**
         * @method 	implementRoom
         * @param 	[codeOrID:string | number]
         * @returns boolean
         */
        NodeSide.implementRoom = "kds.srs-in.nodeside.implementRoom";
        /**
         * @method 	getOtherConfig
         * @param
         * @returns SrsDefine.NodeOtherConfigType
         */
        NodeSide.getOtherConfig = "kds.srs-in.nodeside.getOtherConfig";
        /**
         * @method 	getOtherConfig
         * @param	[userID:number,score:number]
         * @returns number
         */
        NodeSide.userChargeRoom = "kds.srs-in.nodeside.userChargeRoom";
        /**
         * @method 	kickUser
         * @param	[userID:number]
         * @returns number
         */
        NodeSide.userKick = "kds.srs-in.nodeside.kickUser";
        /**
         * @method 	setGameServerStatus
         * @param	[gsTag:string,s:GSDefine.GameServerStatus]
         * @returns boolean
         */
        NodeSide.setGameServerStatus = "kds.srs-in.nodeside.setGameServerStatus";
        /**
         * @method 	getGameServerStatus
         * @param	[gsTag:string]
         * @returns GSDefine.GameServerStatus
         */
        NodeSide.getGameServerStatus = "kds.srs-in.nodeside.getGameServerStatus";
        /**
         * @method 	getAllGameServerStatus
         * @param	[]
         * @returns GSDefine.GameServerStatus[]
         */
        NodeSide.getAllGameServerStatus = "kds.srs-in.nodeside.getAllGameServerStatus";
        /**
         * @method 	callUserActions
         * @param	[eventName:string,jsonObj:any]
         * @returns
         */
        NodeSide.callUserActions = "kds.srs-in.nodeside.callUserActions";
        /**
         * @method 	callUsersActions
         * @param	[userIDs:number[],eventName:string,jsonObj:any]
         * @returns
         */
        NodeSide.callUsersActions = "kds.srs-in.nodeside.callUsersActions";
        /**
         * @method 	userEnterRoomFromGroup
         * @param	[userID:number,groupID:number,codeOrID:string | number,chairNo:number]
         * @returns
         */
        NodeSide.userEnterRoomFromGroup = "kds.srs-in.nodeside.userEnterRoomFromGroup";
        /**
         * @method 	userEnterRoomFromMatch
         * @param	[userID:number,matchID:number,codeOrID:string | number,chairNo:number]
         * @returns
         */
        NodeSide.userEnterRoomFromMatch = "kds.srs-in.nodeside.userEnterRoomFromMatch";
        /**
         * @method 	userExitGroup
         * @param	[userID:number,groupID:number]
         * @returns
         */
        NodeSide.userExitGroup = "kds.srs-in.nodeside.userExitGroup";
        /**
         * @method 	peekGSMsg
         * @param	[data:PeekDefine.PeekData]
         * @returns
         */
        NodeSide.peekGSMsg = "kds.srs-in.nodeside.peekGSMsg";
        /**
         * @method 	robotEnter
         * @param	[userID:numebr,roomID?:number]
         * @returns boolean
         */
        NodeSide.robotEnter = "kds.srs-in.nodeside.robotEnter";
    })(NodeSide = SrsInternal.NodeSide || (SrsInternal.NodeSide = {}));
    // gs 访问 node 的接口
    // 这里是 node 负载均衡通用接口
    // node 也有自己的名字，具体
    let NodeGSSide;
    (function (NodeGSSide) {
        /**
         * @method	getAllNodes
         * @param
         * @returns	SrsDefine.NodeConfigType[]
         */
        NodeGSSide.getAllNodes = "kds.srs-in.nodegsside.getAllNodes";
        /**
         * @method	regGameServer
         * @param	[gameID:number,version:string,company:boolean,params?:SrsDefine.GSParams]
         * @returns	boolean
         */
        NodeGSSide.regGameServer = "kds.srs-in.nodegsside.regGameServer";
        /**
         * @method	routeToUser
         * @param	[userID:number,msgName:string,jsonObj:any]
         * @returns	boolean
         */
        NodeGSSide.routeToUser = "kds.srs-in.nodegsside.route";
        /**
         * @method	userExit
         * @param	[userID:number]
         * @returns
         */
        NodeGSSide.userExit = "kds.srs-in.nodegsside.userExit";
        /**
         * @method	roomEnd
         * @param	[roomID:number,bill:BillDefine.RoomBill]
         * @returns	boolean
         */
        //export const roomEnd = "kds.srs-in.nodegsside.roomEnd"
        /**
         * @method	userReport
         * @param	[roomID:number,userInfo:RoomDefine.ChairUserInfo,onOff:boolean]
         * @returns	boolean
         * @summary call dbp server
         * @summary 玩家在房间内的状态
         */
        //export const userReport = "kds.srs-in.nodegsside.userReport"
        /**
         * @method	roomStatus
         * @param	[roomID:number,status:RoomDefine.RoomStatusType]
         * @returns	boolean
         * @summary call dbp server
         */
        //export const roomStatus = "kds.srs-in.nodegsside.roomStatus"
        /**
         * @method	roomBill
         * @param	[bill:BillDefine.RoomBill]
         * @returns	boolean
         */
        //export const roomBill = "kds.srs-in.nodegsside.roomBill"
        /**
         * @method 	proxyRpcCall
         * @param 	[methodName:string,args:any[]]
         * @returns any
         */
        NodeGSSide.proxyRpcCall = "kds.srs-in.nodegsside.proxyRpcCall";
    })(NodeGSSide = SrsInternal.NodeGSSide || (SrsInternal.NodeGSSide = {}));
    /**
     * robot-logic 访问 node 的接口
     */
    let NodeRobotSide;
    (function (NodeRobotSide) {
        NodeRobotSide.regServer = "kds.srs-in.noderobotside.regRobotLogicServer";
        NodeRobotSide.userEnter = "kds.srs-in.noderobotside.userEnter";
        NodeRobotSide.route = "kds.srs-in.noderobotside.route";
        NodeRobotSide.proxyRpcCall = "kds.srs-in.noderobotside.proxyRpcCall";
        /**
         * @method	getAllNodes
         * @param
         * @returns	SrsDefine.NodeConfigType[]
         */
        NodeRobotSide.getAllNodes = "kds.srs-in.noderobotside.getAllNodes";
    })(NodeRobotSide = SrsInternal.NodeRobotSide || (SrsInternal.NodeRobotSide = {}));
    // node 访问 notify
    let NotifySide;
    (function (NotifySide) {
        /**
         * @method	roomChanged
         * @param	[roomID, changeType]
         * @returns
         */
        NotifySide.roomChanged = "kds.nt-in.node.roomChanged";
    })(NotifySide = SrsInternal.NotifySide || (SrsInternal.NotifySide = {}));
    // gs 和玩家之间路由的
    let GSRouteUser;
    (function (GSRouteUser) {
        GSRouteUser.Route = "SRS-IN.route";
    })(GSRouteUser = SrsInternal.GSRouteUser || (SrsInternal.GSRouteUser = {}));
})(SrsInternal = exports.SrsInternal || (exports.SrsInternal = {}));
