"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
const base_1 = require("kdweb-core/lib/service/base");
const UserDefine_1 = require("../../../kds-base-define/src/UserDefine");
const matchTools_1 = require("../tools/matchTools");
var MatchService;
(function (MatchService) {
    function getMatchList(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let matchDatas;
            if (params.gameID) {
                matchDatas = yield rpc_1.Rpc.center.callException("kds.match.getAll", params.gameID);
            }
            else {
                matchDatas = yield rpc_1.Rpc.center.callException("kds.match.getAll");
            }
            if (matchDatas) {
                return {
                    matchDatas: matchDatas
                };
            }
            return base_1.baseService.errJson(1, "获取列表失败");
        });
    }
    MatchService.getMatchList = getMatchList;
    function getMatchConfig(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let config = yield rpc_1.Rpc.center.callException("kds.match.config.get", params.matchID);
            if (config == null) {
                return base_1.baseService.errJson(1, "配置获取失败");
            }
            return {
                config: config
            };
        });
    }
    MatchService.getMatchConfig = getMatchConfig;
    function getRank(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ranks = yield matchTools_1.MatchTools.getRank(params.matchID, {
                userID: userID,
                limitCount: 100
            });
            if (ranks == null) {
                return base_1.baseService.errJson(1, "获取排行榜失败");
            }
            return {
                ranks: ranks
            };
        });
    }
    MatchService.getRank = getRank;
    function getSelfRecord(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.match.user.getRecord", params.matchID, userID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                record: ret
            };
        });
    }
    MatchService.getSelfRecord = getSelfRecord;
    function getScoreBill(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.match.user.getScoreBill", params.matchID, userID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                scoreBill: ret
            };
        });
    }
    MatchService.getScoreBill = getScoreBill;
    function enterMatch(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.match.user.enter", params.matchID, userID);
            if (ret == null) {
                return base_1.baseService.errJson(1, "服务器错误");
            }
            if (ret.errMsg) {
                return base_1.baseService.errJson(1, ret.errMsg);
            }
            return ret;
        });
    }
    MatchService.enterMatch = enterMatch;
    function enterRoom(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.match.user.enterRoom", params.matchID, userID, params.roomID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    MatchService.enterRoom = enterRoom;
    function userSignUp(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = null;
            if (params.userInfo) {
                ret = yield rpc_1.Rpc.center.callException("kds.match.user.signup", params.matchID, userID, params.userInfo);
            }
            else {
                ret = yield rpc_1.Rpc.center.callException("kds.match.user.signup", params.matchID, userID);
            }
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    MatchService.userSignUp = userSignUp;
    function userGetRooms(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.match.user.getRooms", params.matchID, userID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                rooms: ret
            };
        });
    }
    MatchService.userGetRooms = userGetRooms;
    function getRewardData(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.match.reward.get", userID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                data: ret
            };
        });
    }
    MatchService.getRewardData = getRewardData;
    function gainReward(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let b = yield rpc_1.Rpc.center.callException("kds.match.reward.gain", userID, params.rewardID);
            return {
                success: b
            };
        });
    }
    MatchService.gainReward = gainReward;
    function adminSignUp(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = null;
            if (params.userInfo) {
                ret = yield rpc_1.Rpc.center.callException("kds.match.admin.signup", params.matchID, userID, params.userID, params.userInfo);
            }
            else {
                ret = yield rpc_1.Rpc.center.callException("kds.match.admin.signup", params.matchID, userID, params.userID);
            }
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    MatchService.adminSignUp = adminSignUp;
    function adminUnSignUp(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.match.admin.unsignup", params.matchID, userID, params.userID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    MatchService.adminUnSignUp = adminUnSignUp;
    function adminGetUserInfo(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.match.admin.getUserInfo", params.matchID, userID, params.userID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                userInfo: ret
            };
        });
    }
    MatchService.adminGetUserInfo = adminGetUserInfo;
    function adminGetAllUserInfo(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.match.admin.getAllUserInfos", params.matchID, userID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            let loginDatas = [];
            for (let userInfo of ret) {
                let loginData = yield rpc_1.Rpc.center.callException("kds.dbp.cache.loginData.get", userInfo.userID);
                loginData = UserDefine_1.UserDefine.getUserSideLoginData(loginData);
                loginDatas.push(loginData);
            }
            return {
                userInfos: ret,
                loginDatas: loginDatas,
            };
        });
    }
    MatchService.adminGetAllUserInfo = adminGetAllUserInfo;
    function adminSetUserInfo(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.match.admin.setUserInfo", params.matchID, userID, params.userID, params.userInfo);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: true
            };
        });
    }
    MatchService.adminSetUserInfo = adminSetUserInfo;
    function adminGetRealtime(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.match.admin.getRealtime", params.matchID, userID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                realtime: ret
            };
        });
    }
    MatchService.adminGetRealtime = adminGetRealtime;
    function adminGetRooms(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.match.admin.getRooms", params.matchID, userID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                rooms: ret
            };
        });
    }
    MatchService.adminGetRooms = adminGetRooms;
    function adminCreateRoom(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = null;
            if (params.gameData) {
                ret = yield rpc_1.Rpc.center.callException("kds.match.admin.createRoom", params.matchID, userID, params.gameData);
            }
            else {
                ret = yield rpc_1.Rpc.center.callException("kds.match.admin.createRoom", params.matchID, userID);
            }
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                room: ret
            };
        });
    }
    MatchService.adminCreateRoom = adminCreateRoom;
    function adminJiesanRoom(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.match.admin.jiesanRoom", params.matchID, userID, params.roomID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    MatchService.adminJiesanRoom = adminJiesanRoom;
    //步步为赢一把牌临时生成牌
    function adminInitCards() {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.match.admin.initCards");
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    MatchService.adminInitCards = adminInitCards;
})(MatchService = exports.MatchService || (exports.MatchService = {}));
