"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
const base_1 = require("kdweb-core/lib/service/base");
const UserErrorCode_1 = require("../../../kds-base-define/src/UserErrorCode");
var RoomService;
(function (RoomService) {
    function createRoom(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let roomData = yield rpc_1.Rpc.center.callException("kds.room.create.lobby", userID, params.gameData);
            if (roomData == null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLobby, "创建房间失败");
            }
            rpc_1.Rpc.center.call("kds.dbp.record.room", userID, roomData.roomID, roomData.boxCode, roomData.gameData, roomData.teaExt);
            return {
                roomData: roomData
            };
        });
    }
    RoomService.createRoom = createRoom;
    function createTeaRoom(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let roomData = yield rpc_1.Rpc.center.callException("kds.room.create.tea", userID, params.gameData, params.teaExt);
            if (roomData == null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLobby, "创建房间失败");
            }
            rpc_1.Rpc.center.call("kds.dbp.record.room", userID, roomData.roomID, roomData.boxCode, roomData.gameData, roomData.teaExt);
            return {
                roomData: roomData
            };
        });
    }
    RoomService.createTeaRoom = createTeaRoom;
    function getWechatShareID(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let id = yield rpc_1.Rpc.center.callException("kds.wechat.room.getShareID", "WM-GZ", params.roomID);
            return {
                shareID: id,
            };
        });
    }
    RoomService.getWechatShareID = getWechatShareID;
    // enterRoom 消息直接发 srs 就可以了
    // export async function enterRoom(sk:string,userID:number,params:{
    // }) {
    // }
})(RoomService = exports.RoomService || (exports.RoomService = {}));
