"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
const base_1 = require("kdweb-core/lib/service/base");
const UserErrorCode_1 = require("../../../kds-base-define/src/UserErrorCode");
function linkToTeaRpc(method) {
    return function (sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException(method, sk, userID, params);
            if (ret == null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorTea, "服务器响应失败");
            }
            return ret;
        });
    };
}
var TeaService;
(function (TeaService) {
    function enter(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
        });
    }
    TeaService.enter = enter;
    function getList(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let teaIDs = yield rpc_1.Rpc.center.callException("kds.tea.user.getAllTeaIDs", userID);
            return {
                teaIDs: teaIDs ? teaIDs : []
            };
        });
    }
    TeaService.getList = getList;
    function getTeaFullData(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let data = yield rpc_1.Rpc.center.callException("kds.tea.user.getFullData", userID, params.teaIDOrCode);
            if (typeof (data) == "string") {
                return base_1.baseService.errJson(1, data);
            }
            return {
                fullData: data
            };
        });
    }
    TeaService.getTeaFullData = getTeaFullData;
    function getTeaSimpleData(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let data = yield rpc_1.Rpc.center.callException("kds.tea.user.getSimpleData", userID, params.teaIDOrCode);
            if (typeof (data) == "string") {
                return base_1.baseService.errJson(1, data);
            }
            return {
                fullData: data
            };
        });
    }
    TeaService.getTeaSimpleData = getTeaSimpleData;
    function getTeaRooms(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let data = yield rpc_1.Rpc.center.callException("kds.tea.user.getRooms", userID, params.teaID);
            return {
                rooms: data
            };
        });
    }
    TeaService.getTeaRooms = getTeaRooms;
    function jiesanRoom(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.tea.user.jiesanRoom", userID, params.teaID, params.codeOrID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    TeaService.jiesanRoom = jiesanRoom;
    function createRoom(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let roomData = yield rpc_1.Rpc.center.callException("kds.tea.user.createRoom", userID, params.gameData, params.teaExt);
            if (roomData == null || typeof (roomData) == "string") {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLobby, "创建房间失败");
            }
            rpc_1.Rpc.center.call("kds.dbp.record.room", userID, roomData.roomID, roomData.boxCode, roomData.gameData, roomData.teaExt);
            return {
                roomData: roomData
            };
        });
    }
    TeaService.createRoom = createRoom;
    function createTea(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.tea.user.createTea", userID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                teaID: ret
            };
        });
    }
    TeaService.createTea = createTea;
    function charge(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.tea.user.charge", userID, params.teaID, params.count);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    TeaService.charge = charge;
    function addTemplate(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = null;
            if (params.name) {
                ret = yield rpc_1.Rpc.center.callException("kds.tea.template.add", userID, params.teaID, params.gameData, params.teaExt, params.name);
            }
            else {
                ret = yield rpc_1.Rpc.center.callException("kds.tea.template.add", userID, params.teaID, params.gameData, params.teaExt);
            }
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    TeaService.addTemplate = addTemplate;
    function renameTemplate(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.tea.template.rename", userID, params.teaID, params.templateID, params.name);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    TeaService.renameTemplate = renameTemplate;
    function updateTemplate(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.tea.template.update", userID, params.teaID, params.templateID, params.gameData);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    TeaService.updateTemplate = updateTemplate;
    function removeTemplate(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.tea.template.remove", userID, params.teaID, params.templateID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    TeaService.removeTemplate = removeTemplate;
    function createRoomByTemplate(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.tea.template.create", userID, params.teaID, params.templateID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                roomID: ret
            };
        });
    }
    TeaService.createRoomByTemplate = createRoomByTemplate;
    function addAdmin(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.tea.admin.add", userID, params.teaID, params.userID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    TeaService.addAdmin = addAdmin;
    function removeAdmin(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.tea.admin.remove", userID, params.teaID, params.userID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    TeaService.removeAdmin = removeAdmin;
    function updateAuth(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.tea.admin.updateAuth", userID, params.teaID, params.auth);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    TeaService.updateAuth = updateAuth;
    function memberReq(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.tea.member.req", userID, params.teaID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    TeaService.memberReq = memberReq;
    function memberRefuse(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.tea.member.refuse", userID, params.teaID, params.userID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    TeaService.memberRefuse = memberRefuse;
    function memberAgree(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.tea.member.agree", userID, params.teaID, params.userID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    TeaService.memberAgree = memberAgree;
    function memberRemove(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.tea.member.remove", userID, params.teaID, params.userID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    TeaService.memberRemove = memberRemove;
    function memberInviteSearch(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.tea.member.invite.search", userID, params.teaID, params.userID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                loginData: ret
            };
        });
    }
    TeaService.memberInviteSearch = memberInviteSearch;
    function memberInvite(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.tea.member.invite.invite", userID, params.teaID, params.userID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    TeaService.memberInvite = memberInvite;
    function memberInviteAgree(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.tea.member.invite.agree", userID, params.teaID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    TeaService.memberInviteAgree = memberInviteAgree;
    function memberInviteRefuse(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.tea.member.invite.refuse", userID, params.teaID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    TeaService.memberInviteRefuse = memberInviteRefuse;
    function memberInviteRemove(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.tea.member.invite.remove", userID, params.teaID, params.userID);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    TeaService.memberInviteRemove = memberInviteRemove;
    function accountValue(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.tea.value.changeValue", userID, params.teaID, params.userID, params.num);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    TeaService.accountValue = accountValue;
    function accountCount(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.tea.value.changeCount", userID, params.teaID, params.userID, params.num);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    TeaService.accountCount = accountCount;
    function setProxyType(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.tea.proxy.setProxyType", userID, params.teaID, params.userID, params.proxyType);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    TeaService.setProxyType = setProxyType;
    function setDeskCost(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.tea.proxy.setDeskCost", userID, params.teaID, params.targetUserID, params.costs);
            if (typeof (ret) == "string") {
                return base_1.baseService.errJson(1, ret);
            }
            return {
                success: ret
            };
        });
    }
    TeaService.setDeskCost = setDeskCost;
    function getDeskCost(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let costs = yield rpc_1.Rpc.center.callException("kds.tea.proxy.getDeskCost", userID, params.teaID, params.targetUserID);
            return {
                costs: costs,
            };
        });
    }
    TeaService.getDeskCost = getDeskCost;
    function getUserValueRecord(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let records = yield rpc_1.Rpc.center.callException("kds.tea.record.userValue", params.userID, params.teaID);
            return {
                records: records || [],
            };
        });
    }
    TeaService.getUserValueRecord = getUserValueRecord;
    function getTeaValueRecord(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let records = yield rpc_1.Rpc.center.callException("kds.tea.record.teaValue", userID, params.teaID);
            return {
                records: records || [],
            };
        });
    }
    TeaService.getTeaValueRecord = getTeaValueRecord;
    function getTeaData(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let data = yield rpc_1.Rpc.center.callException("kds.tea.user.get.data", userID, params.teaID);
            if (typeof (data) == "string") {
                return base_1.baseService.errJson(1, data);
            }
            return {
                teaData: data
            };
        });
    }
    TeaService.getTeaData = getTeaData;
    function getTeaMember(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let data = yield rpc_1.Rpc.center.callException("kds.tea.user.get.member", userID, params.teaID);
            if (typeof (data) == "string") {
                return base_1.baseService.errJson(1, data);
            }
            return {
                teaMember: data
            };
        });
    }
    TeaService.getTeaMember = getTeaMember;
    function getSimpleTeaMember(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let data = yield rpc_1.Rpc.center.callException("kds.tea.user.get.simpleMember", userID, params.teaID);
            if (typeof (data) == "string") {
                return base_1.baseService.errJson(1, data);
            }
            return {
                teaMember: data
            };
        });
    }
    TeaService.getSimpleTeaMember = getSimpleTeaMember;
    function getTeaTemplate(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let data = yield rpc_1.Rpc.center.callException("kds.tea.user.get.template", userID, params.teaID);
            if (typeof (data) == "string") {
                return base_1.baseService.errJson(1, data);
            }
            return {
                teaTemplate: data
            };
        });
    }
    TeaService.getTeaTemplate = getTeaTemplate;
    function getTeaAccount(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let data = yield rpc_1.Rpc.center.callException("kds.tea.user.get.account", userID, params.teaID);
            if (typeof (data) == "string") {
                return base_1.baseService.errJson(1, data);
            }
            return {
                teaAccount: data
            };
        });
    }
    TeaService.getTeaAccount = getTeaAccount;
    function getTeaAuth(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let data = yield rpc_1.Rpc.center.callException("kds.tea.user.get.auth", userID, params.teaID);
            if (typeof (data) == "string") {
                return base_1.baseService.errJson(1, data);
            }
            return {
                teaAuth: data
            };
        });
    }
    TeaService.getTeaAuth = getTeaAuth;
    function getTeaUserBill(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let data = yield rpc_1.Rpc.center.callException("kds.bill.daily.teaUser", params.teaID, params.lastCount || 0);
            return {
                data: data
            };
        });
    }
    TeaService.getTeaUserBill = getTeaUserBill;
    function getTeaFundBill(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let data = yield rpc_1.Rpc.center.callException("kds.bill.daily.teaFund", params.teaID, params.lastCount || 0);
            return {
                data: data
            };
        });
    }
    TeaService.getTeaFundBill = getTeaFundBill;
    function getTeaFundUserBill(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let data = yield rpc_1.Rpc.center.callException("kds.bill.daily.teaFundUser", params.teaID, params.userID, params.lastCount || 0);
            return {
                data: data
            };
        });
    }
    TeaService.getTeaFundUserBill = getTeaFundUserBill;
})(TeaService = exports.TeaService || (exports.TeaService = {}));
