"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const wcore = require("kdweb-core");
const config_1 = require("./config");
const rpc_1 = require("./rpc");
const lobby_1 = require("./service/lobby");
const room_1 = require("./service/room");
const bill_1 = require("./service/bill");
const common_1 = require("./tools/common");
const award_1 = require("./service/award");
const match_1 = require("./service/match");
const tea_1 = require("./service/tea");
const mail_1 = require("./service/mail");
const compression = require("compression");
const log_1 = require("./log");
const path = require("path");
function lambda(func, bypass = false) {
    return common_1.AKVerifyService(func, bypass);
}
let app = new wcore.service.entity(config_1.Config.otherConfig.userPort);
app.app.use(compression());
app.setAllowOrigin();
log_1.Log.oth.info('app kds-lobby====>', JSON.stringify(app));
log_1.Log.oth.info('servicePort kds-lobby===>', config_1.Config.otherConfig.userPort);
app.addInstance("/login", lambda(lobby_1.LobbyService.loginLobby));
//新增实名业务
//2023-09-04 zhb注销实名业务
//app.addInstance("/setRealname", lambda(lobby_1.LobbyService.setRealname));
//app.addInstance("/getRealname", lambda(lobby_1.LobbyService.getRealname));
app.addInstance("/wechat/auth", lambda(lobby_1.LobbyService.getOpenId));
app.addInstance("/channel/bind", lambda(lobby_1.LobbyService.bindChannel));
app.addInstance("/ad/bind", lambda(lobby_1.LobbyService.bindAdvertisement));
app.addInstance("/userInfo", lambda(lobby_1.LobbyService.getUserInfo));
app.addInstance("/group/list", lambda(lobby_1.LobbyService.getGroupList));
app.addInstance("/group/get", lambda(lobby_1.LobbyService.getGroup));
app.addInstance("/group/usercount", lambda(lobby_1.LobbyService.getGroupUserCount));
app.addInstance("/group/gameusercount", lambda(lobby_1.LobbyService.getGroupGameUserCount));
app.addInstance("/match/list", lambda(match_1.MatchService.getMatchList));
app.addInstance("/match/config", lambda(match_1.MatchService.getMatchConfig));
//2023-09-04 zhb注销步步为排行榜业务
//app.addInstance("/match/bbwy/rank", lambda(match_1.MatchService.getBbwyRank));
//app.addInstance("/match/bbwy/zhuangandxian", lambda(match_1.MatchService.getZhuangAndXian, true));
app.addInstance("/match/rank", lambda(match_1.MatchService.getRank));
app.addInstance("/match/enter", lambda(match_1.MatchService.enterMatch));
app.addInstance("/match/enterroom", lambda(match_1.MatchService.enterRoom));
app.addInstance("/match/rooms", lambda(match_1.MatchService.userGetRooms));
app.addInstance("/match/selfrecord", lambda(match_1.MatchService.getSelfRecord));
app.addInstance("/match/scorebill", lambda(match_1.MatchService.getScoreBill));
app.addInstance("/match/signup", lambda(match_1.MatchService.userSignUp));
app.addInstance("/match/delRankAll", lambda(lobby_1.LobbyService.delRankAll));
app.addInstance("/match/reward/get", lambda(match_1.MatchService.getRewardData));
app.addInstance("/match/reward/gain", lambda(match_1.MatchService.gainReward));
app.addInstance("/match/admin/signup", lambda(match_1.MatchService.adminSignUp));
app.addInstance("/match/admin/unsignup", lambda(match_1.MatchService.adminUnSignUp));
app.addInstance("/match/admin/userinfo", lambda(match_1.MatchService.adminGetUserInfo));
app.addInstance("/match/admin/alluserinfos", lambda(match_1.MatchService.adminGetAllUserInfo));
app.addInstance("/match/admin/setuserinfo", lambda(match_1.MatchService.adminSetUserInfo));
app.addInstance("/match/admin/realtime", lambda(match_1.MatchService.adminGetRealtime));
app.addInstance("/match/admin/rooms", lambda(match_1.MatchService.adminGetRooms));
app.addInstance("/match/admin/createroom", lambda(match_1.MatchService.adminCreateRoom));
app.addInstance("/match/admin/jiesanroom", lambda(match_1.MatchService.adminJiesanRoom));
app.addInstance("/room/create", lambda(room_1.RoomService.createRoom));
app.addInstance("/room/wechat/shareid", lambda(room_1.RoomService.getWechatShareID));
app.addInstance("/bill/get", lambda(bill_1.BillService.getBill));
app.addInstance("/bill/room", lambda(bill_1.BillService.getRoomBills));
app.addInstance("/fupan/get", lambda(bill_1.BillService.getFupan));
app.addInstance("/cursor/bill/user", lambda(bill_1.BillCursorService.getBill));
app.addInstance("/cursor/bill/tea", lambda(bill_1.BillCursorService.getTeaBill));
app.addInstance("/cursor/bill/teauser", lambda(bill_1.BillCursorService.getTeaUserBill));
app.addInstance("/award/wechatshare", lambda(award_1.AwardService.wxShare));
app.addInstance("/award/wechatad", lambda(award_1.AwardService.wxAd));
app.addInstance("/award/gold/daily", lambda(award_1.AwardService.daily));
app.addInstance("/award/gold/free", lambda(award_1.AwardService.free));
app.addInstance("/award/gold/setawardkey", lambda(award_1.AwardService.setAwardkey));
app.addInstance("/award/gold/sappshare", lambda(award_1.AwardService.sappShare));
app.addInstance("/award/gold/adfailedshare", lambda(award_1.AwardService.adFailedShare));
app.addInstance("/mail/list", lambda(mail_1.MailService.getMails));
app.addInstance("/mail/read", lambda(mail_1.MailService.readMail));
app.addInstance("/mail/remove", lambda(mail_1.MailService.removeMail));
app.addInstance("/room/tea/create", lambda(room_1.RoomService.createTeaRoom));
app.addInstance("/info/rename", lambda(lobby_1.LobbyService.rename));
app.addInstance("/info/changepwd", lambda(lobby_1.LobbyService.changePwd));
app.addInstance("/info/changeicon", lambda(lobby_1.LobbyService.changeIcon));
app.addInstance("/info/msgcheck", lambda(lobby_1.LobbyService.msgCheck));
app.addInstance("/info/msgchecknew", lambda(lobby_1.LobbyService.msgCheckNew));
app.addInstance("/tea/user/enter", lambda(tea_1.TeaService.enter));
app.addInstance("/tea/user/list", lambda(tea_1.TeaService.getList));
app.addInstance("/tea/user/jiesanroom", lambda(tea_1.TeaService.jiesanRoom));
app.addInstance("/tea/user/createroom", lambda(tea_1.TeaService.createRoom));
app.addInstance("/tea/user/getdata", lambda(tea_1.TeaService.getTeaFullData));
app.addInstance("/tea/user/getsimpledata", lambda(tea_1.TeaService.getTeaSimpleData));
app.addInstance("/tea/user/rooms", lambda(tea_1.TeaService.getTeaRooms));
app.addInstance("/tea/user/create", lambda(tea_1.TeaService.createTea));
app.addInstance("/tea/user/charge", lambda(tea_1.TeaService.charge));
app.addInstance("/tea/user/get/data", lambda(tea_1.TeaService.getTeaData));
app.addInstance("/tea/user/get/member", lambda(tea_1.TeaService.getTeaMember));
app.addInstance("/tea/user/get/simplemember", lambda(tea_1.TeaService.getSimpleTeaMember));
app.addInstance("/tea/user/get/template", lambda(tea_1.TeaService.getTeaTemplate));
app.addInstance("/tea/user/get/account", lambda(tea_1.TeaService.getTeaAccount));
app.addInstance("/tea/user/get/auth", lambda(tea_1.TeaService.getTeaAuth));
app.addInstance("/tea/template/add", lambda(tea_1.TeaService.addTemplate));
app.addInstance("/tea/template/rename", lambda(tea_1.TeaService.renameTemplate));
app.addInstance("/tea/template/update", lambda(tea_1.TeaService.updateTemplate));
app.addInstance("/tea/template/remove", lambda(tea_1.TeaService.removeTemplate));
app.addInstance("/tea/template/create", lambda(tea_1.TeaService.createRoomByTemplate));
app.addInstance("/tea/admin/add", lambda(tea_1.TeaService.addAdmin));
app.addInstance("/tea/admin/remove", lambda(tea_1.TeaService.removeAdmin));
app.addInstance("/tea/admin/auth", lambda(tea_1.TeaService.updateAuth));
app.addInstance("/tea/member/req", lambda(tea_1.TeaService.memberReq));
app.addInstance("/tea/member/refuse", lambda(tea_1.TeaService.memberRefuse));
app.addInstance("/tea/member/agree", lambda(tea_1.TeaService.memberAgree));
app.addInstance("/tea/member/remove", lambda(tea_1.TeaService.memberRemove));
app.addInstance("/tea/member/invite", lambda(tea_1.TeaService.memberInvite));
app.addInstance("/tea/member/invite/search", lambda(tea_1.TeaService.memberInviteSearch));
app.addInstance("/tea/member/invite/refuse", lambda(tea_1.TeaService.memberInviteRefuse));
app.addInstance("/tea/member/invite/agree", lambda(tea_1.TeaService.memberInviteAgree));
app.addInstance("/tea/member/invite/remove", lambda(tea_1.TeaService.memberInviteRemove));
app.addInstance("/tea/account/count", lambda(tea_1.TeaService.accountCount));
app.addInstance("/tea/account/value", lambda(tea_1.TeaService.accountValue));
app.addInstance("/tea/proxy/settype", lambda(tea_1.TeaService.setProxyType));
app.addInstance("/tea/proxy/setcost", lambda(tea_1.TeaService.setDeskCost));
app.addInstance("/tea/proxy/getcost", lambda(tea_1.TeaService.getDeskCost));
app.addInstance("/tea/record/user", lambda(tea_1.TeaService.getUserValueRecord));
app.addInstance("/tea/record/tea", lambda(tea_1.TeaService.getTeaValueRecord));
app.addInstance("/tea/daily/user", lambda(tea_1.TeaService.getTeaUserBill));
app.addInstance("/tea/daily/fund", lambda(tea_1.TeaService.getTeaFundBill));
app.addInstance("/tea/daily/funduser", lambda(tea_1.TeaService.getTeaFundUserBill));
app.listen();
rpc_1.Rpc.init();
let localConfig = config_1.Config.localConfig;
if (localConfig.extName) {
    try {
        let projDirname = path.resolve();
        let filePath = path.join(projDirname, "..", localConfig.extName, "lib", localConfig.extName, "src", "start.js");
        console.log("path = " + filePath);
		log_1.Log.oth.info("path = " + filePath);
        let ext = require(filePath);
        ext.init({
            app: app,
            rpc: rpc_1.Rpc.center
        });
    }
    catch (error) {
        log_1.Log.oth.error("error to load ext name = " + localConfig.extName, error);
    }
}
