"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var TeaDefine;
(function (TeaDefine) {
    let TeaSelfType;
    (function (TeaSelfType) {
        TeaSelfType[TeaSelfType["None"] = 0] = "None";
        TeaSelfType[TeaSelfType["Own"] = 1] = "Own";
        TeaSelfType[TeaSelfType["Req"] = 2] = "Req";
        TeaSelfType[TeaSelfType["Admin"] = 3] = "Admin";
        TeaSelfType[TeaSelfType["Member"] = 4] = "Member";
    })(TeaSelfType = TeaDefine.TeaSelfType || (TeaDefine.TeaSelfType = {}));
    let TeaUserAccountChangedType;
    (function (TeaUserAccountChangedType) {
        TeaUserAccountChangedType[TeaUserAccountChangedType["System"] = 0] = "System";
        // 上级操作		
        TeaUserAccountChangedType[TeaUserAccountChangedType["Leader"] = 100] = "Leader";
        // 修改
        TeaUserAccountChangedType[TeaUserAccountChangedType["Give"] = 200] = "Give";
        // 游戏变动
        TeaUserAccountChangedType[TeaUserAccountChangedType["Game"] = 800] = "Game";
        // 桌费
        TeaUserAccountChangedType[TeaUserAccountChangedType["Cost"] = 801] = "Cost";
        // 桌费收入
        TeaUserAccountChangedType[TeaUserAccountChangedType["CostEarn"] = 802] = "CostEarn";
    })(TeaUserAccountChangedType = TeaDefine.TeaUserAccountChangedType || (TeaDefine.TeaUserAccountChangedType = {}));
    let TeaFriendChangedType;
    (function (TeaFriendChangedType) {
        TeaFriendChangedType[TeaFriendChangedType["Add"] = 0] = "Add";
        TeaFriendChangedType[TeaFriendChangedType["Remove"] = 1] = "Remove";
        TeaFriendChangedType[TeaFriendChangedType["Update"] = 2] = "Update";
    })(TeaFriendChangedType = TeaDefine.TeaFriendChangedType || (TeaDefine.TeaFriendChangedType = {}));
    let TeaModeType;
    (function (TeaModeType) {
        TeaModeType[TeaModeType["Normal"] = 0] = "Normal";
        TeaModeType[TeaModeType["Union"] = 1] = "Union";
        TeaModeType[TeaModeType["Fund"] = 2] = "Fund";
    })(TeaModeType = TeaDefine.TeaModeType || (TeaDefine.TeaModeType = {}));
    let TeaStatus;
    (function (TeaStatus) {
        TeaStatus[TeaStatus["Normal"] = 0] = "Normal";
        TeaStatus[TeaStatus["Closed"] = 1] = "Closed";
    })(TeaStatus = TeaDefine.TeaStatus || (TeaDefine.TeaStatus = {}));
    let TeaProxyType;
    (function (TeaProxyType) {
        TeaProxyType[TeaProxyType["None"] = 0] = "None";
        TeaProxyType[TeaProxyType["Normal"] = 1] = "Normal";
        TeaProxyType[TeaProxyType["Super"] = 2] = "Super";
    })(TeaProxyType = TeaDefine.TeaProxyType || (TeaDefine.TeaProxyType = {}));
    let Record;
    (function (Record) {
        let ValueAccountType;
        (function (ValueAccountType) {
            ValueAccountType[ValueAccountType["Account"] = 0] = "Account";
            ValueAccountType[ValueAccountType["Value"] = 1] = "Value";
        })(ValueAccountType = Record.ValueAccountType || (Record.ValueAccountType = {}));
        let MemberType;
        (function (MemberType) {
            MemberType[MemberType["Add"] = 0] = "Add";
            MemberType[MemberType["Remove"] = 1] = "Remove";
            MemberType[MemberType["Req"] = 2] = "Req";
            MemberType[MemberType["Accept"] = 3] = "Accept";
            MemberType[MemberType["Refuse"] = 4] = "Refuse";
            MemberType[MemberType["Invite"] = 5] = "Invite";
            MemberType[MemberType["RemoveInvite"] = 6] = "RemoveInvite";
            MemberType[MemberType["AgreeInvite"] = 7] = "AgreeInvite";
        })(MemberType = Record.MemberType || (Record.MemberType = {}));
    })(Record = TeaDefine.Record || (TeaDefine.Record = {}));
    let Fund;
    (function (Fund) {
        function toReal(num) {
            return Math.floor(num * 100);
        }
        Fund.toReal = toReal;
        function toShow(num) {
            return Math.floor(num) / 100;
        }
        Fund.toShow = toShow;
    })(Fund = TeaDefine.Fund || (TeaDefine.Fund = {}));
})(TeaDefine = exports.TeaDefine || (exports.TeaDefine = {}));
