"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const controller_1 = require("./controller");
const CommonMsg_1 = require("../../../kds-base-define/src/CommonMsg");
const log_1 = require("../log");
const WorkDefine_1 = require("../../../kds-base-define/src/WorkDefine");
const work_1 = require("../service/work");
let workRedisTableName = "t_lobby_dlgz_work";
class WorkPeek_Result_GameID1 extends controller_1.PeekEntityBase {
    get name() {
        return "WorkPeek_Result_GameID1";
    }
    get gameID() {
        return 1;
    }
    get msgName() {
        return CommonMsg_1.GameCommonMsg.ResultWork;
    }
    onPeek(data) {
        return __awaiter(this, void 0, void 0, function* () {
            // return await super.onPeek(data)
            let t = data.jsonObj;
            log_1.Log.oth.info("[WorkPeek_Result_GameID1] onPeek t:", t);
            for (const user of t.users) {
                let save = false;
                let workData = yield work_1.WorkService.handleWorkData(user.userInfoData.userID);
                // Log.oth.info("[WorkPeek_Result_GameID1] workData",workData);
                workData.works.forEach(v => {
                    // Log.oth.info("[WorkPeek_Result_GameID1] v",v);
                    if (v.cur < v.max) {
                        switch (v.type) {
                            case WorkDefine_1.WorkDefine.WorkType.Play:
                                // 对局数
                                if (t.groupID) {
                                    v.cur++;
                                    save = true;
                                }
                                break;
                            case WorkDefine_1.WorkDefine.WorkType.Win:
                                // 胜场数
                                if (t.groupID && this.getSelfIsWin(t, user.chairNo)) {
                                    v.cur++;
                                    save = true;
                                }
                                break;
                            case WorkDefine_1.WorkDefine.WorkType.GanGuo:
                                // 参与干锅对局次数
                                if (t.groupID && t.ganGuo) {
                                    v.cur++;
                                    save = true;
                                }
                                break;
                            case WorkDefine_1.WorkDefine.WorkType.Blood:
                                // 喝血次数
                                if (t.groupID && t.bloodCount > 0 && this.getSelfIsWin(t, user.chairNo)) {
                                    v.cur++;
                                    save = true;
                                }
                                break;
                            case WorkDefine_1.WorkDefine.WorkType.BaoDong:
                                // 参与暴动对局次数
                                if (t.groupID && t.baoDong) {
                                    v.cur++;
                                    save = true;
                                }
                                break;
                            default:
                                break;
                        }
                    }
                });
                if (save) {
                    // await Rpc.center.callException("kds.dbp.kv.sett", workRedisTableName, user.userInfoData.userID.toString(), JSON.stringify(workData.data))
                    yield work_1.WorkService.setWorkKv(user.userInfoData.userID, JSON.stringify(workData));
                }
            }
        });
    }
    getSelfIsWin(t, chairNo) {
        let winUserList = t.userScores.filter(v => v.data != 0);
        return winUserList.find(v => v.chairNo == chairNo);
    }
    onTask(userID, chairNo, taskData, t) {
        return false;
    }
}
exports.WorkPeek_Result_GameID1 = WorkPeek_Result_GameID1;
