"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
const utils_1 = require("kdweb-core/lib/utils");
const base_1 = require("kdweb-core/lib/service/base");
const store_1 = require("./store");
const lobbyTools_1 = require("../tools/lobbyTools");
const task_1 = require("./task");
const work_1 = require("./work");
const WorkDefine_1 = require("../../../kds-base-define/src/WorkDefine");
let dailyTableName = "t_lobby_award_daily";
let sappTableName = "t_lobby_sappshare_daily";
let sappShareCount = 2;
let chackinTableName = "t_lobby_dlgz_chackin";
var AwardService;
(function (AwardService) {
    function wxShare(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            //Rpc.center.call("kds.wechat.award.share",userID)
            return {};
        });
    }
    AwardService.wxShare = wxShare;
    function wxAd(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            //Rpc.center.call("kds.wechat.award.advertisement",userID)
            return {};
        });
    }
    AwardService.wxAd = wxAd;
    // 新版
    function daily(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let date = utils_1.kdutils.getFmtMoment("YYYY-MM-DD");
            let userDate = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", dailyTableName, userID.toString());
            if (userDate == date) {
                return base_1.baseService.errJson(1, "今日已经领取过了");
            }
            let count = 5000;
            if (params.ad) {
                count = 10000;
            }
            // let count = 10000
            // if(params.ad) {
            // 	count = 20000
            // }
            yield rpc_1.Rpc.center.call("kds.inpay.user.gold", userID, count);
            let data = {
                money: [{ moneyID: store_1.ItemID.gold, count: count }],
                prop: []
            };
            yield rpc_1.Rpc.center.callException("kds.nt.changed.user.award", userID, data);
            rpc_1.Rpc.center.callException("kds.dbp.kv.sett", dailyTableName, userID.toString(), date);
            return {
                goldCount: count
            };
        });
    }
    AwardService.daily = daily;
    // 老版
    // export async function daily(sk:string,userID:number,params:{
    // 	ad:boolean
    // }) {
    // 	let date = kdutils.getFmtMoment("YYYY-MM-DD")
    // 	let userDate:string = await Rpc.center.callException("kds.dbp.kv.gett",dailyTableName,userID.toString())
    // 	if(userDate == date) {
    // 		return baseService.errJson(1,"今日已经领取过了")
    // 	}
    // 	let count = 10000
    // 	if(params.ad) {
    // 		count = 20000
    // 	}
    // 	await Rpc.center.call("kds.inpay.user.gold",userID,count)
    // 	Rpc.center.callException("kds.dbp.kv.sett",dailyTableName,userID.toString(),date)
    // 	return {
    // 		goldCount:count
    // 	}
    // }
    // 老版
    // export async function free(sk: string, userID: number, params: {}) {
    // 	let msg = await Rpc.center.call("kds.dbp.new.gold.getAward", userID)
    // 	if(msg.data.status) {
    // 		let count = 10000
    // 		await Rpc.center.call("kds.inpay.user.gold", userID, count)
    // 		return {goldCount: count}
    // 	}else{
    // 		return baseService.errJson(1, "获取视频奖励失败，请重新观看视频")
    // 	}
    // }
    // 新版
    function free(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let t_award_count_free = 't_award_count_free';
            let time = Math.floor(new Date().getTime() / 1000);
            let date = utils_1.kdutils.getFmtMoment("YYYY-MM-DD");
            let str = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", t_award_count_free, userID.toString());
            let expData = yield rpc_1.Rpc.center.callException("kds.dbp.recharge.getExp", userID);
            let ret = yield rpc_1.Rpc.center.callException("kds.dbp.task.monthlycard.get", { sk: sk });
            let delayed = 10;
            let sum = 10;
            if (expData && expData.count >= 400) {
                sum++;
            }
            let t = null;
            if (str == null) {
                t = {
                    time: time,
                    count: 0,
                    date: date,
                    maxCount: sum,
                };
            }
            else {
                t = JSON.parse(str);
                if (!ret || time > ret.endTime) {
                    if (Number(time) - Number(t.time) < delayed) {
                        return base_1.baseService.errJson(1, "获取视频奖励失败，请重新观看视频");
                    }
                }
                let c = lobbyTools_1.LobbyTools.isTimestampToday(t.time * 1000);
                t.maxCount = sum;
                if (!c) {
                    t.count = 0;
                }
            }
            if (t.count >= t.maxCount) {
                return base_1.baseService.errJson(1, "今日领取次数不足");
            }
            t.count++;
            t.time = time;
            t.date = date;
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", t_award_count_free, userID.toString(), JSON.stringify(t));
            // let count = 10000
            let count = 5000;
            if (expData) {
                if (expData.count >= 30) {
                    // count += count * 0.7
                    count += count;
                }
                else if (expData.count >= 6) {
                    count += count * 0.3;
                }
            }
            yield rpc_1.Rpc.center.call("kds.inpay.user.gold", userID, count);
            let data = {
                money: [{ moneyID: store_1.ItemID.gold, count: count }],
                prop: []
            };
            yield rpc_1.Rpc.center.callException("kds.nt.changed.user.award", userID, data);
            return {
                goldCount: count,
                count: t.maxCount - t.count
            };
        });
    }
    AwardService.free = free;
    /** 新增破产补助 */
    function bkptSubsidy(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let userInfo = yield rpc_1.Rpc.center.callException("kds.dbp.user.userInfo.get", userID);
            if (userInfo == null) {
                return base_1.baseService.errJson(1, "找不到玩家信息");
            }
            if (userInfo.goldCount >= 10000) {
                return base_1.baseService.errJson(1, "金币数量超过10000，无法领取");
            }
            let t_award_count_bkptSubsidy = 't_award_count_bkptSubsidy';
            let time = Math.floor(new Date().getTime() / 1000);
            let date = utils_1.kdutils.getFmtMoment("YYYY-MM-DD");
            let str = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", t_award_count_bkptSubsidy, userID.toString());
            let expData = yield rpc_1.Rpc.center.callException("kds.dbp.recharge.getExp", userID);
            let ret = yield rpc_1.Rpc.center.callException("kds.dbp.task.monthlycard.get", { sk: sk });
            let delayed = 10;
            let t = null;
            if (str == null) {
                t = {
                    time: time,
                    date: date
                };
            }
            else {
                t = JSON.parse(str);
                // 有月卡跳过广告
                if (!ret || time > ret.endTime) {
                    if (Number(time) - Number(t.time) < delayed) {
                        return base_1.baseService.errJson(1, "获取视频奖励失败，请重新观看视频");
                    }
                }
            }
            t.time = time;
            t.date = date;
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", t_award_count_bkptSubsidy, userID.toString(), JSON.stringify(t));
            let count = 10000 - userInfo.goldCount;
            yield rpc_1.Rpc.center.call("kds.inpay.user.gold", userID, count);
            let data = {
                money: [{ moneyID: store_1.ItemID.gold, count: count }],
                prop: []
            };
            yield rpc_1.Rpc.center.callException("kds.nt.changed.user.award", userID, data);
            return {
                goldCount: count
            };
        });
    }
    AwardService.bkptSubsidy = bkptSubsidy;
    function setAwardkey(sk, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            yield rpc_1.Rpc.center.call("kds.dbp.new.gold.setAward", userID);
            return { status: true };
        });
    }
    AwardService.setAwardkey = setAwardkey;
    // 新版
    function sappShare(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let date = utils_1.kdutils.getFmtMoment("YYYY-MM-DD");
            let str = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", sappTableName, userID.toString());
            let t;
            if (str == null) {
                t = {
                    date: date,
                    count: 0,
                };
            }
            else {
                t = JSON.parse(str);
                if (t.date != date) {
                    t.count = 0;
                    t.date = date;
                }
            }
            if (t.count >= sappShareCount) {
                return base_1.baseService.errJson(1, "每日最多领取" + sappShareCount + "次哦");
            }
            t.count++;
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", sappTableName, userID.toString(), JSON.stringify(t));
            let count = 5000;
            yield rpc_1.Rpc.center.call("kds.inpay.user.gold", userID, count);
            let data = {
                money: [{ moneyID: store_1.ItemID.gold, count: count }],
                prop: []
            };
            yield rpc_1.Rpc.center.callException("kds.nt.changed.user.award", userID, data);
            //任务分享
            // let workData = await WorkService.handleWorkData(userID)
            // let obj = workData.works.find(v => v.type == WorkDefine.WorkType.Share)
            // if(obj.cur < obj.max) {
            // 	obj.cur++
            // 	await WorkService.setWorkKv(userID, JSON.stringify(workData))
            // }
            yield work_1.WorkService.completeWork(WorkDefine_1.WorkDefine.WorkType.Share, userID);
            return {
                goldCount: count
            };
        });
    }
    AwardService.sappShare = sappShare;
    // 老版
    // export async function sappShare(sk:string,userID:number,params:{}) {
    // 	let date = kdutils.getFmtMoment("YYYY-MM-DD")
    // 	let str:string = await Rpc.center.callException("kds.dbp.kv.gett",sappTableName,userID.toString())
    // 	let t:sappShareType 
    // 	if(str == null) {
    // 		t = {
    // 			date:date,
    // 			count:0,
    // 		}
    // 	} else {
    // 		t = JSON.parse(str)
    // 		if(t.date != date) {
    // 			t.count = 0
    // 			t.date = date 
    // 		}
    // 	}
    // 	if(t.count >= 1) {
    // 		return baseService.errJson(1,"每日最多领取1次哦")
    // 	}
    // 	t.count ++
    // 	await Rpc.center.callException("kds.dbp.kv.sett",sappTableName,userID.toString(),JSON.stringify(t))
    // 	let count = 5000
    // 	await Rpc.center.call("kds.inpay.user.gold",userID,count)
    // 	return {
    // 		goldCount:count
    // 	}
    // }
    // 新版
    function adFailedShare(sk, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let userInfo = yield rpc_1.Rpc.center.callException("kds.dbp.user.userInfo.get", userID);
            if (userInfo == null) {
                return base_1.baseService.errJson(1, "找不到玩家信息");
            }
            if (userInfo.goldCount >= 20000) {
                return base_1.baseService.errJson(1, "金币数量超过20000，无法领取");
            }
            let count = 5000;
            yield rpc_1.Rpc.center.call("kds.inpay.user.gold", userID, count);
            let data = {
                money: [{ moneyID: store_1.ItemID.gold, count: count }],
                prop: []
            };
            yield rpc_1.Rpc.center.callException("kds.nt.changed.user.award", userID, data);
            return {
                goldCount: count
            };
        });
    }
    AwardService.adFailedShare = adFailedShare;
    // 老版
    // export async function adFailedShare(sk:string,userID:number) {
    // 	let userInfo:UserDefine.UserInfoData = await Rpc.center.callException("kds.dbp.user.userInfo.get",userID)
    // 	if(userInfo == null) {
    // 		return baseService.errJson(1,"找不到玩家信息")
    // 	}
    // 	if(userInfo.goldCount >= 20000) {
    // 		return baseService.errJson(1,"金币数量超过20000，无法领取")
    // 	}
    // 	let count = 5000
    // 	await Rpc.center.call("kds.inpay.user.gold",userID,count)
    // 	return {
    // 		goldCount:count
    // 	}
    // }
    function getRewardCount(ak, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let t_award_count_free = 't_award_count_free';
            let str = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", t_award_count_free, userID.toString());
            let expData = yield rpc_1.Rpc.center.callException("kds.dbp.recharge.getExp", userID);
            let sapp = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", sappTableName, userID.toString());
            let date = utils_1.kdutils.getFmtMoment("YYYY-MM-DD");
            let t = null;
            let sappData = null;
            let sum = 10;
            if (expData && expData.count >= 400) {
                sum++;
            }
            if (str == null) {
                t = {
                    time: Math.floor(new Date().getTime() / 1000),
                    count: 0,
                    date: date,
                    maxCount: sum,
                };
                yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", t_award_count_free, userID.toString(), JSON.stringify(t));
            }
            else {
                t = JSON.parse(str);
                t.maxCount = sum;
                let c = lobbyTools_1.LobbyTools.isTimestampToday(t.time * 1000);
                if (!c) {
                    t.count = 0;
                    yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", t_award_count_free, userID.toString(), JSON.stringify(t));
                }
            }
            if (sapp == null) {
                sappData = {
                    date: date,
                    count: 0,
                };
            }
            else {
                sappData = JSON.parse(sapp);
                if (sappData.date != date) {
                    sappData.count = 0;
                    sappData.date = date;
                }
            }
            return {
                count: t.maxCount - t.count,
                asppCount: sappData.count,
                asppMaxCount: sappShareCount
            };
        });
    }
    AwardService.getRewardCount = getRewardCount;
    function getReward(ak, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let time = Date.now();
            yield task_1.TaskService.setMonthlyCardReward(userID, ak);
            let data = yield rpc_1.Rpc.center.callException("kds.dbp.task.monthlycard.get", { sk: ak });
            if (data) {
                let prop = data.prop.find((msg) => msg.propID == 200000);
                if (prop && time >= prop.startTime && time <= prop.endTime) {
                    return { propID: 200000 };
                }
            }
            return { propID: 200001 };
        });
    }
    AwardService.getReward = getReward;
    let accumList = [
        { today: 2, rewardID: 100002, rewardCount: 100, rewardStatus: false },
        { today: 3, rewardID: 100002, rewardCount: 200, rewardStatus: false },
        { today: 5, rewardID: 100002, rewardCount: 300, rewardStatus: false },
        { today: 6, rewardID: 100002, rewardCount: 500, rewardStatus: false }
    ];
    // 签到信息
    function getChackinData(ak, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let chackinData = yield rpc_1.Rpc.center.callException("kds.dbp.chackin.get");
            let userData = yield lobbyTools_1.LobbyTools.getkv(chackinTableName, userID.toString());
            let signCount = chackinData.length;
            let callData = [];
            let date = utils_1.kdutils.getMillionSecond();
            let today = lobbyTools_1.LobbyTools.getWeekNumber();
            // let today: number = 7;
            let accumData = JSON.parse(JSON.stringify(accumList));
            // if (userData && userData.startCheckinDate) {
            // 	date = Math.abs(LobbyTools.daysFromNow(userData.startCheckinDate));
            // } else {
            // 	date = 0;  // 或者设定一个合理的默认值
            // }
            if (!userData || userData.awardDates.length != signCount || date >= userData.prevCreateDate) {
                let tims = AwardTools.getChackinAwardDates(signCount);
                userData = {
                    checkinDays: 0,
                    startCheckinDate: 0,
                    awardDates: tims,
                    lastCheckinDate: 0,
                    accumuReceived: 0,
                    prevCreateDate: lobbyTools_1.LobbyTools.getEndOfWeekTimestamp()
                };
                chackinData.forEach(msg => {
                    callData.push({
                        idx: msg.idx,
                        itemID: msg.itemID,
                        ad: msg.ad,
                        name: msg.name,
                        rewardCount: msg.rewardCount,
                        rewardID: msg.rewardID,
                        canResign: msg.idx < today,
                        sign: false,
                    });
                });
                yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", chackinTableName, userID.toString(), JSON.stringify(userData));
                date = 0;
            }
            else {
                userData.checkinDays = 0;
                chackinData.forEach(msg => {
                    callData.push({
                        idx: msg.idx,
                        itemID: msg.itemID,
                        ad: msg.ad,
                        name: msg.name,
                        rewardCount: msg.rewardCount,
                        rewardID: msg.rewardID,
                        canResign: false,
                        sign: false,
                    });
                });
                let update = false;
                callData.forEach(msg => {
                    let day = userData.awardDates.find(s => s.today == msg.idx);
                    if (day.today < today && day.time == null) {
                        msg.canResign = true;
                    }
                    if (day.today <= today && day.time != null) {
                        userData.checkinDays += 1;
                    }
                    if (day.today > today && day.time != null) {
                        day.time = null;
                        msg.sign = null;
                        update = true;
                    }
                    else {
                        if (day.time != null) {
                            userData.lastCheckinDate = day.time;
                        }
                        msg.sign = day.time != null;
                    }
                });
                accumData.forEach((msg, index) => {
                    if (msg.today > today) {
                        msg.rewardStatus = false;
                    }
                    else if (msg.today <= userData.accumuReceived) {
                        msg.rewardStatus = true;
                    }
                });
                for (let i = accumData.length - 1; i >= 0; i--) {
                    if (accumData[i].rewardStatus === true) {
                        userData.accumuReceived = accumData[i].today;
                        break;
                    }
                }
                if (update) {
                    userData.prevCreateDate = lobbyTools_1.LobbyTools.getEndOfWeekTimestamp();
                    yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", chackinTableName, userID.toString(), JSON.stringify(userData));
                }
            }
            return {
                accumCur: userData.checkinDays,
                accumMax: accumData[accumData.length - 1].today,
                accumList: accumData,
                chackinList: callData,
                now: today
            };
        });
    }
    AwardService.getChackinData = getChackinData;
    // 签到
    function chackin(ak, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let chackinData = yield rpc_1.Rpc.center.callException("kds.dbp.chackin.get");
            let userData = yield lobbyTools_1.LobbyTools.getkv(chackinTableName, userID.toString());
            if (!userData) {
                return base_1.baseService.errJson(1, "信息错误");
            }
            if (lobbyTools_1.LobbyTools.isTimestampToday(userData.lastCheckinDate)) {
                return base_1.baseService.errJson(1, "今日已签到过");
            }
            let date = new Date().getTime();
            // let nowDate = Math.abs(LobbyTools.daysFromNow(userData.startCheckinDate));
            let nowDate = lobbyTools_1.LobbyTools.getWeekNumber();
            // let nowDate = 7;
            let dayMsg;
            // if(userData.startCheckinDate != 0) {
            dayMsg = userData.awardDates.find(s => s.time == null && s.today == nowDate);
            // }else{
            // 	 dayMsg = userData.awardDates.find(s => s.today == 1);
            // }
            dayMsg.time = date;
            userData.lastCheckinDate = date;
            userData.checkinDays++;
            userData.startCheckinDate == 0 && (userData.startCheckinDate = date);
            let chackinDay = chackinData.find(s => s.idx == dayMsg.today);
            let count = chackinDay.rewardCount;
            if (chackinDay.ad && params.ad) {
                count += count;
            }
            let data = {
                money: [{ moneyID: chackinDay.rewardID, count: count }],
                prop: []
            };
            yield work_1.WorkService.completeWork(WorkDefine_1.WorkDefine.WorkType.Sign, userID);
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", chackinTableName, userID.toString(), JSON.stringify(userData));
            yield lobbyTools_1.LobbyTools.addItem(userID, data.money);
            lobbyTools_1.LobbyTools.issueItem(userID, data, '签到');
            yield rpc_1.Rpc.center.callException("kds.nt.changed.user.award", userID, data);
            return true;
        });
    }
    AwardService.chackin = chackin;
    // 补签
    function reChackin(ak, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let chackinData = yield rpc_1.Rpc.center.callException("kds.dbp.chackin.get");
            let userData = yield lobbyTools_1.LobbyTools.getkv(chackinTableName, userID.toString());
            if (!userData) {
                return base_1.baseService.errJson(1, "信息错误");
            }
            let dayMsg = userData.awardDates.find(s => s.today == params.idx);
            if (!dayMsg) {
                return base_1.baseService.errJson(1, "补签信息错误");
            }
            if (dayMsg.time != null) {
                return base_1.baseService.errJson(1, "该日期已补签过");
            }
            let date = new Date().getTime();
            dayMsg.time = date;
            // userData.lastCheckinDate = date;
            userData.checkinDays++;
            let chackinDay = chackinData.find(s => s.idx == dayMsg.today);
            let count = chackinDay.rewardCount;
            if (params.ad) {
                count += count;
            }
            let data = {
                money: [{ moneyID: chackinDay.rewardID, count: count }],
                prop: []
            };
            yield work_1.WorkService.completeWork(WorkDefine_1.WorkDefine.WorkType.Sign, userID);
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", chackinTableName, userID.toString(), JSON.stringify(userData));
            yield lobbyTools_1.LobbyTools.addItem(userID, data.money);
            lobbyTools_1.LobbyTools.issueItem(userID, data, '补签');
            yield rpc_1.Rpc.center.callException("kds.nt.changed.user.award", userID, data);
            return true;
        });
    }
    AwardService.reChackin = reChackin;
    // 累计签到
    function accumulate(ak, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let userData = yield lobbyTools_1.LobbyTools.getkv(chackinTableName, userID.toString());
            if (!userData) {
                return base_1.baseService.errJson(1, "信息错误");
            }
            let data = {
                money: [],
                prop: []
            };
            let accumData = JSON.parse(JSON.stringify(accumList));
            let rewardClaimed = false; // 标记是否成功领取了奖励
            for (const accum of accumData) {
                if (accum.today <= userData.checkinDays && accum.today > userData.accumuReceived) {
                    userData.accumuReceived = accum.today;
                    data.money.push({ moneyID: accum.rewardID, count: accum.rewardCount });
                    rewardClaimed = true; // 标记成功领取奖励
                }
            }
            if (!rewardClaimed) {
                // 如果没有领取到任何奖励
                return base_1.baseService.errJson(1, "没有可领取的奖励");
            }
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", chackinTableName, userID.toString(), JSON.stringify(userData));
            yield lobbyTools_1.LobbyTools.addItem(userID, data.money);
            lobbyTools_1.LobbyTools.issueItem(userID, data, '领取累计签到奖励');
            yield rpc_1.Rpc.center.callException("kds.nt.changed.user.award", userID, data);
            yield lobbyTools_1.LobbyTools.updateItems(userID);
            return true;
        });
    }
    AwardService.accumulate = accumulate;
    // 记牌器活动
    let t_award_count_card = 't_award_count_card';
    function getCardRecorderCount(sk, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let obj = yield lobbyTools_1.LobbyTools.getkv(t_award_count_card, userID.toString());
            let t = null;
            let adMaxCount = 10;
            let shareMaxCount = 2;
            if (obj == null) {
                t = {
                    time: Math.floor(new Date().getTime()),
                    adCount: 0,
                    adMaxCount: adMaxCount,
                    shareCount: 0,
                    shareMaxCount: shareMaxCount,
                };
                yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", t_award_count_card, userID.toString(), JSON.stringify(t));
            }
            else {
                t = obj;
                let c = lobbyTools_1.LobbyTools.isTimestampToday(t.time);
                if (!c) {
                    t.adCount = 0;
                    t.shareCount = 0;
                    t.time = Math.floor(new Date().getTime());
                    yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", t_award_count_card, userID.toString(), JSON.stringify(t));
                }
            }
            return {
                adCount: t.adMaxCount - t.adCount,
                shareCount: t.shareMaxCount - t.shareCount
            };
        });
    }
    AwardService.getCardRecorderCount = getCardRecorderCount;
    function receiveCardRecorder(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let t = yield lobbyTools_1.LobbyTools.getkv(t_award_count_card, userID.toString());
            if (!t) {
                return base_1.baseService.errJson(1, "信息错误");
            }
            let count = 0;
            let maxCount = 0;
            if (params.type == 0) {
                t.adCount++;
                count = t.adCount;
                maxCount = t.adMaxCount;
            }
            else {
                t.shareCount++;
                count = t.shareCount;
                maxCount = t.shareMaxCount;
            }
            if (count > maxCount) {
                return base_1.baseService.errJson(1, "今日领取次数不足");
            }
            let data = {
                money: [],
                prop: [{ propID: 200010, count: 1 }]
            };
            yield rpc_1.Rpc.center.callException("kds.inpay.prop.awardAdd", userID, sk, data.prop);
            yield rpc_1.Rpc.center.callException("kds.nt.changed.user.award", userID, data);
            lobbyTools_1.LobbyTools.issueItem(userID, data, '领取记牌器');
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", t_award_count_card, userID.toString(), JSON.stringify(t));
            yield work_1.WorkService.completeWork(WorkDefine_1.WorkDefine.WorkType.Share, userID);
            return true;
        });
    }
    AwardService.receiveCardRecorder = receiveCardRecorder;
})(AwardService = exports.AwardService || (exports.AwardService = {}));
var AwardTools;
(function (AwardTools) {
    function getDaily(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let date = utils_1.kdutils.getFmtMoment("YYYY-MM-DD");
            let userDate = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", dailyTableName, userID.toString());
            return date != userDate;
        });
    }
    AwardTools.getDaily = getDaily;
    function getChackinAwardDates(day) {
        let times = [];
        for (let i = 0; i < day; i++) {
            times.push({
                today: i + 1,
                time: null,
            });
        }
        return times;
    }
    AwardTools.getChackinAwardDates = getChackinAwardDates;
    function getLastSignTime(data) {
        return Math.max(...data.filter(item => item.time !== null).map(item => item.today));
    }
    AwardTools.getLastSignTime = getLastSignTime;
})(AwardTools = exports.AwardTools || (exports.AwardTools = {}));
// [
// 	{
// 		today: 1,
// 		time: 1719763200000
// 	},
// 	{
// 		today: 2,
// 		time: null
// 	},
// 	{
// 		today: 3,
// 		time: null
// 	},
// 	{
// 		today: 4,
// 		time: 1719763200000
// 	},
// 	{
// 		today: 5,
// 		time: null
// 	},
// 	{
// 		today: 6,
// 		time: null
// 	},
// 	{
// 		today: 7,
// 		time: null
// 	}
// ]
