"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const base_1 = require("kdweb-core/lib/service/base");
const log_1 = require("../log");
const rpc_1 = require("../rpc");
function ItemServiceFunction(func) {
    return function (sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = null;
            //let wait = await TaskService.waitTask(userID)
            try {
                ret = yield func(userID, params);
            }
            catch (error) {
                log_1.Log.oth.error("[item-service] error = ", error);
            }
            //TaskService.endTask(userID,wait)
            return ret ? ret : base_1.baseService.errJson(1, "道具请求失败");
        });
    };
}
exports.ItemServiceFunction = ItemServiceFunction;
var ItemService;
(function (ItemService) {
    function getItems(userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let items = yield rpc_1.Rpc.center.callException("kds.dbp.item.getAll", userID);
            return {
                items: items || []
            };
        });
    }
    ItemService.getItems = getItems;
    function useItem(userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
        });
    }
    ItemService.useItem = useItem;
})(ItemService = exports.ItemService || (exports.ItemService = {}));
