"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("kdweb-core/lib/utils");
const WorkDefine_1 = require("../../../kds-base-define/src/WorkDefine");
const rpc_1 = require("../rpc");
const lobbyTools_1 = require("../tools/lobbyTools");
const log_1 = require("../log");
const _ = require("underscore");
const base_1 = require("kdweb-core/lib/service/base");
const MutexDefine_1 = require("../../../kds-base-define/src/MutexDefine");
let workRedisTableName = "t_lobby_dlgz_work";
function WorkServiceFunction(func) {
    return function (sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = null;
            yield WorkService.waitWork(userID);
            try {
                ret = yield func(userID, params);
            }
            catch (error) {
                log_1.Log.oth.error("[task-service] error = ", error);
            }
            WorkService.endWork(userID);
            return ret ? ret : base_1.baseService.errJson(1, "任务请求失败");
        });
    };
}
exports.WorkServiceFunction = WorkServiceFunction;
function WorkMutexFunction(userID, func) {
    return __awaiter(this, void 0, void 0, function* () {
        let ret = null;
        yield WorkService.waitWork(userID);
        try {
            ret = yield func();
        }
        catch (error) {
            log_1.Log.oth.error("[task-service] mutex error = ", error);
        }
        WorkService.endWork(userID);
        return ret;
    });
}
exports.WorkMutexFunction = WorkMutexFunction;
var WorkService;
(function (WorkService) {
    function waitWork(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            yield rpc_1.Rpc.center.callException("kds.mutex.get", MutexDefine_1.MutexDefine.LobbyTask(userID), 10000);
        });
    }
    WorkService.waitWork = waitWork;
    function endWork(userID) {
        rpc_1.Rpc.center.callException("kds.mutex.release", MutexDefine_1.MutexDefine.LobbyTask(userID));
    }
    WorkService.endWork = endWork;
    function setWorkKv(userID, keyData) {
        return __awaiter(this, void 0, void 0, function* () {
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", workRedisTableName, userID.toString(), keyData);
            return true;
        });
    }
    WorkService.setWorkKv = setWorkKv;
    function getWorkList(sk, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let userData = yield handleWorkData(userID);
            if (!userData) {
                return base_1.baseService.errJson(1, "任务数据错误");
            }
            let workData = yield rpc_1.Rpc.center.callException('kds.dbp.work.getAll');
            let list = [];
            // for(let obj of userData.works) {
            //     let work = workData.find(v => v.workID == obj.workID)
            //     list.push({
            //         workID: obj.workID,
            //         awards:work.awards,
            //         cur: obj.cur,
            //         max: obj.max,
            //         name: obj.name,
            //         gain: obj.gain,
            //         type: obj.type,
            //         tag: work.tag,
            //     })
            // }
            for (let obj of workData) {
                let work = userData.works.find(v => v.workID == obj.workID);
                list.push({
                    workID: obj.workID,
                    awards: obj.awards,
                    cur: work.cur,
                    max: work.max,
                    name: work.name,
                    gain: work.gain,
                    type: work.type,
                    tag: obj.tag,
                });
            }
            return {
                works: list
            };
        });
    }
    WorkService.getWorkList = getWorkList;
    function reward(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let data = yield lobbyTools_1.LobbyTools.getkv(workRedisTableName, userID.toString());
            if (data == null) {
                return base_1.baseService.errJson(1, "没有找到数据");
            }
            let work = data.works.find(v => v.workID == params.workID);
            if (work == null) {
                return base_1.baseService.errJson(1, "没有找到任务信息");
            }
            if (work.gain) {
                return base_1.baseService.errJson(1, "不能重复领取");
            }
            if (work.cur < work.max) {
                return base_1.baseService.errJson(1, "任务还没完成");
            }
            let workData = yield rpc_1.Rpc.center.callException('kds.dbp.work.getAll');
            let config = workData.find(v => v.workID == work.workID);
            if (config == null) {
                return base_1.baseService.errJson(1, "没有任务配置");
            }
            work.gain = true;
            // await Rpc.center.callException("kds.dbp.kv.sett", workRedisTableName, userID.toString(), JSON.stringify(data))
            yield setWorkKv(userID, JSON.stringify(data));
            let rewardData = {
                money: [],
                prop: []
            };
            config.awards.forEach((v) => __awaiter(this, void 0, void 0, function* () {
                // 看广告双倍
                params.ad && (v.count += v.count);
                rewardData.money.push({ moneyID: v.id, count: v.count });
            }));
            log_1.Log.oth.info('[reward] money', rewardData.money);
            yield lobbyTools_1.LobbyTools.addItem(userID, rewardData.money);
            yield rpc_1.Rpc.center.callException("kds.nt.changed.user.award", userID, rewardData);
            yield lobbyTools_1.LobbyTools.updateItems(userID);
            return {};
        });
    }
    WorkService.reward = reward;
    function handleWorkData(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let data = yield lobbyTools_1.LobbyTools.getkv(workRedisTableName, userID.toString());
            let workData;
            let today = utils_1.kdutils.getFmtMoment("YYYY-MM-DD");
            let curTime = utils_1.kdutils.getMillionSecond();
            let save = false;
            if (!data) {
                data = {
                    works: [],
                    prevCreateDate: null,
                };
                // }
            }
            else {
                workData = yield rpc_1.Rpc.center.callException('kds.dbp.work.getAll');
                log_1.Log.oth.info('handleWorkData workData:', workData);
                // workData.forEach((v:WorkDefine.WorkData) => {
                //     let result = data.works.find(m => m.workID == v.workID);
                //     if(!result) {
                //         let newData: WorkDefine.UserWork = createWorkUserData(v,curTime)
                //         data.works.push(newData)
                //         save = true;
                //     }else{
                //         let time = LobbyTools.getEndOfWeekTimestamp();
                //         if(v.tag == WorkDefine.WorkTag.Weekly && result.endTime != time) {
                //             result.cur = 0;
                //             result.endTime = time;
                //             save = true;
                //         }
                //     }
                // })
            }
            let refresh = true;
            if (data.prevCreateDate != today) {
                // 之前有刷新过任务
                if (data.prevCreateDate != null) {
                    // 判断今天的时间有没有到刷新时间
                    let refreshTime = Number.parseInt(utils_1.kdutils.mometFunc(today + " " + "0", "YYYY-MM-DD HH").format("x"));
                    if (curTime < refreshTime) {
                        refresh = false;
                    }
                }
            }
            else {
                refresh = false;
            }
            if (refresh) {
                workData = yield rpc_1.Rpc.center.callException('kds.dbp.work.getAll');
                data.prevCreateDate = today;
                save = true;
                let newWorks = [];
                // 判断任务是否过期
                for (let work of data.works) {
                    let config = workData.find(v => v.workID == work.workID);
                    if (config == null) {
                        log_1.Log.oth.info("[work] user work invalid userID = " + userID + " work = ", config);
                        continue;
                    }
                    // -1 为长期任务
                    if (work.endTime == -1 || curTime < work.endTime) {
                        newWorks.push(work);
                        continue;
                    }
                    log_1.Log.oth.info("[work] user work timeout userID = " + userID + " workID = " + work.workID);
                }
                data.works = [];
                let configs = workData;
                if (configs.length == 0) {
                    return;
                }
                let idConfigInfos = [];
                for (let config of configs) {
                    let info = idConfigInfos.find(v => v.workID == config.workID);
                    if (info) {
                        info.configs.push(config);
                    }
                    else {
                        info = {
                            workID: config.workID,
                            configs: [config]
                        };
                        idConfigInfos.push(info);
                    }
                }
                configs.splice(0);
                for (let info of idConfigInfos) {
                    info.configs = _.shuffle(info.configs);
                    configs.push(info.configs[0]);
                }
                for (let config of configs) {
                    // switch (config.tag) {
                    //     case WorkDefine.WorkTag.Day:
                    //         timeout = Number.parseInt(kdutils.mometFunc(kdutils.getFmtMoment("YYYY-MM-DD", curTime + (24 * (60 * 60 * 1000))) + " " + "0", "YYYY-MM-DD HH").format("x"))
                    //         break;
                    //     case WorkDefine.WorkTag.Weekly:
                    //         timeout = Number.parseInt(kdutils.mometFunc(kdutils.getFmtMoment("YYYY-MM-DD", curTime + ((24 * (60 * 60 * 1000)) * 7)) + " " + "0", "YYYY-MM-DD HH").format("x"))
                    //         break;
                    //     case WorkDefine.WorkTag.Unique:
                    //         timeout = -1
                    //         break;
                    //     default:
                    //         break;
                    // }
                    // let endTime = timeout;
                    let oldWork = newWorks.find(v => v.workID == config.workID);
                    // let newData: WorkDefine.UserWork = {
                    //     workID: config.workID,
                    //     startTime: curTime,
                    //     endTime: endTime,
                    //     cur: 0,
                    //     max: config.max,
                    //     gain: false,
                    //     type: config.type,
                    //     name: config.name,
                    // }
                    let newData = createWorkUserData(config, curTime);
                    data.works.push(oldWork || newData);
                }
            }
            if (save) {
                yield setWorkKv(userID, JSON.stringify(data));
            }
            return data;
        });
    }
    WorkService.handleWorkData = handleWorkData;
    function completeWork(type, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let save = false;
            let workData = yield WorkService.handleWorkData(userID);
            workData.works.forEach(v => {
                if (v.type == type && v.cur < v.max) {
                    v.cur++;
                    save = true;
                }
            });
            if (save) {
                yield WorkService.setWorkKv(userID, JSON.stringify(workData));
            }
            return save;
        });
    }
    WorkService.completeWork = completeWork;
    // 任务 收藏小游戏
    function collectGame(sk, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let res = yield completeWork(WorkDefine_1.WorkDefine.WorkType.Collect, userID);
            return {
                status: res
            };
        });
    }
    WorkService.collectGame = collectGame;
    // 任务 添加到桌面
    function addDesktop(sk, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let res = yield completeWork(WorkDefine_1.WorkDefine.WorkType.AddDesktop, userID);
            return {
                status: res
            };
        });
    }
    WorkService.addDesktop = addDesktop;
    function getCollect(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let userData = yield handleWorkData(userID);
            if (!userData) {
                return null;
            }
            let collect = userData.works.find(v => v.type == WorkDefine_1.WorkDefine.WorkType.Collect);
            return collect.cur < collect.max;
        });
    }
    WorkService.getCollect = getCollect;
    function getAddDesktop(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let userData = yield handleWorkData(userID);
            if (!userData) {
                return null;
            }
            let collect = userData.works.find(v => v.type == WorkDefine_1.WorkDefine.WorkType.AddDesktop);
            return collect.cur < collect.max;
        });
    }
    WorkService.getAddDesktop = getAddDesktop;
    function createWorkUserData(config, curTime) {
        let timeout = 0;
        switch (config.tag) {
            case WorkDefine_1.WorkDefine.WorkTag.Day:
                timeout = Number.parseInt(utils_1.kdutils.mometFunc(utils_1.kdutils.getFmtMoment("YYYY-MM-DD", curTime + (24 * (60 * 60 * 1000))) + " " + "0", "YYYY-MM-DD HH").format("x"));
                break;
            case WorkDefine_1.WorkDefine.WorkTag.Weekly:
                // timeout = Number.parseInt(kdutils.mometFunc(kdutils.getFmtMoment("YYYY-MM-DD", curTime + ((24 * (60 * 60 * 1000)) * 7)) + " " + "0", "YYYY-MM-DD HH").format("x"))
                timeout = lobbyTools_1.LobbyTools.getEndOfWeekTimestamp();
                break;
            case WorkDefine_1.WorkDefine.WorkTag.Unique:
                timeout = -1;
                break;
            default:
                break;
        }
        return {
            workID: config.workID,
            startTime: curTime,
            endTime: timeout,
            cur: 0,
            max: config.max,
            gain: false,
            type: config.type,
            name: config.name,
        };
    }
    WorkService.createWorkUserData = createWorkUserData;
})(WorkService = exports.WorkService || (exports.WorkService = {}));
