"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const KVDefine_1 = require("../../../kds-base-define/src/KVDefine");
const MatchDefine_1 = require("../../../kds-base-define/src/MatchDefine");
const log_1 = require("../log");
const rpc_1 = require("../rpc");
const async_1 = require("kdweb-core/lib/tools/async");
let changedRank = new Map();
var MatchTools;
(function (MatchTools) {
    function getRank(matchID, opt) {
        return __awaiter(this, void 0, void 0, function* () {
            opt = opt || {};
            let userInfos = yield async_1.kdasync.queueFunc(_getRank)(matchID);
            if (userInfos == null) {
                return [];
            }
            let selfUserInfo = null;
            if (opt.userID != null) {
                selfUserInfo = userInfos.find(v => v.userID == opt.userID);
            }
            if (opt.limitCount != null) {
                userInfos = userInfos.slice(0, opt.limitCount);
            }
            if (selfUserInfo) {
                userInfos.splice(0, 0, selfUserInfo);
            }
            return userInfos;
        });
    }
    MatchTools.getRank = getRank;
    function _getRank(matchID) {
        return __awaiter(this, void 0, void 0, function* () {
            let t = changedRank.get(matchID);
            let rt = yield rpc_1.Rpc.center.callException("kds.dbp.kv.c.get", MatchDefine_1.MatchDefine.getMatchRankChangedName(matchID), t ? t.tag : KVDefine_1.KVDefine.NULL);
            let str = null;
            if (rt == null) {
                str = t ? t.data : null;
            }
            else {
                if (rt.changed == false) {
                    str = t ? t.data : null;
                }
                else {
                    str = rt.data;
                    changedRank.set(matchID, rt);
                }
            }
            if (str == null) {
                log_1.Log.oth.error("[match] get match rank failed id = " + matchID, rt);
                return null;
            }
            let userInfos = JSON.parse(str);
            return userInfos;
        });
    }
})(MatchTools = exports.MatchTools || (exports.MatchTools = {}));
