"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const centerClient_1 = require("kdweb-core/lib/rpc/center/centerClient");
const ServerConfig_1 = require("../../kds-base-define/src/ServerConfig");
const config_1 = require("./config");
var Rpc;
(function (Rpc) {
    function init() {
        if (ServerConfig_1.ServerValues.localIp) {
            centerClient_1.kdRpcCenterClient.setupLocalHostReplacement(ServerConfig_1.ServerValues.localIp);
        }
        Rpc.center = new centerClient_1.kdRpcCenterClient.entity({
            centerHost: ServerConfig_1.ServerValues.rpcCenterHost,
            port: config_1.Config.myConfig.wsPort,
            token: ServerConfig_1.ServerValues.rpcToken,
            info: {
                name: config_1.Config.myName,
                tag: config_1.Config.myName,
                host: config_1.Config.myConfig.wsHost,
                auth: "Vash",
                version: "1.0",
                timestamp: 0,
                data: null
            }
        });
        Rpc.center.logUrlPath = ServerConfig_1.ServerValues.rpcLoggerHost;
        // let wechatConfig = ServerConfig.getConfig("s-wechat")
        // center.checkStartConnect({
        // 	name: wechatConfig.name,
        // 	tag: wechatConfig.name,
        // 	host: wechatConfig.wsHost,
        // 	auth: "Vash",
        // 	version: "1.0",
        // 	timestamp:null,
        // 	data:null,
        // })
    }
    Rpc.init = init;
})(Rpc = exports.Rpc || (exports.Rpc = {}));
