"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
const base_1 = require("kdweb-core/lib/service/base");
const UserErrorCode_1 = require("../../../kds-base-define/src/UserErrorCode");
const log_1 = require("../log");
var WechatService;
(function (WechatService) {
    function login(params) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                let t = yield rpc_1.Rpc.center.callException("kds.wechat.login", params.gameName, params.code);
                if (t == null) {
                    return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Login_WechatAuth, "微信授权失败");
                }
                return { openId: t.openId };
            }
            catch (error) {
                log_1.Log.oth.info("[wechat-login] rpc call exception = ", error);
            }
            return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Login_WechatAuth, "微信授权失败");
        });
    }
    WechatService.login = login;
    // zhb 2023/10/25 新增头像安全2.0
    function iconUrlS(params) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                let t = yield rpc_1.Rpc.center.callException("kds.wechat.room.mediaCheck", params.gameName, params.content, params.openid, params.media_type, params.apiID);
                return true;
            }
            catch (error) {
                log_1.Log.oth.info("[wechat-login] rpc call exception = ", error);
            }
            return null;
        });
    }
    WechatService.iconUrlS = iconUrlS;
    // zhb 2023/10/25 新增头像安全2.0
    function UnickName(params) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                let t = yield rpc_1.Rpc.center.callException("kds.wechat.room.msgCheckNew", params.gameName, params.content, params.apiID);
                return t;
            }
            catch (error) {
                log_1.Log.oth.info("[wechat-login] rpc call exception = ", error);
            }
            return false;
        });
    }
    WechatService.UnickName = UnickName;
})(WechatService = exports.WechatService || (exports.WechatService = {}));
