"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatchExtensions = void 0;
const MatchDefine_1 = require("./MatchDefine");
var MatchExtensions;
(function (MatchExtensions) {
    function makeGroupTypeExtData(type) {
        let ret = {};
        switch (type) {
            case MatchDefine_1.MatchDefine.MatchGroupType.ModeGrade:
                {
                    ret.count = 0;
                    ret.time = 0;
                    ret.values = [];
                }
                break;
            default: {
                return null;
            }
        }
        return ret;
    }
    MatchExtensions.makeGroupTypeExtData = makeGroupTypeExtData;
    function parseModeGradeData(data) {
        if (data.values == null || data.values.length == 0) {
            return null;
        }
        let ret = {
            grades: [],
            steps: [],
        };
        let idx = 0;
        let count = data.values[idx++];
        for (let i = idx; i < idx + count * 3; i += 3) {
            ret.grades.push({
                min: data.values[i + 0],
                max: data.values[i + 1],
                num: data.values[i + 2],
            });
        }
        idx += count * 3;
        count = data.values[idx++];
        for (let i = idx; i < idx + count * 2; i += 2) {
            ret.steps.push({
                timeout: data.values[i + 0],
                offset: data.values[i + 1],
            });
        }
        return ret;
    }
    MatchExtensions.parseModeGradeData = parseModeGradeData;
    function encodeModeGradeData(grade, data) {
        data = data || {};
        data.values = [];
        data.values.push(grade.grades.length);
        for (let t of grade.grades) {
            data.values.push(t.min);
            data.values.push(t.max);
            data.values.push(t.num);
        }
        data.values.push(grade.steps.length);
        for (let t of grade.steps) {
            data.values.push(t.timeout);
            data.values.push(t.offset);
        }
        return data;
    }
    MatchExtensions.encodeModeGradeData = encodeModeGradeData;
})(MatchExtensions = exports.MatchExtensions || (exports.MatchExtensions = {}));
