"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MutexFunctional = exports.MutexDefine = void 0;
var MutexDefine;
(function (MutexDefine) {
    function UserInfo(userID) {
        return "UserInfo|UserID=" + userID;
    }
    MutexDefine.UserInfo = UserInfo;
    function TeaData(teaID) {
        return "TeaData|TeaID=" + teaID;
    }
    MutexDefine.TeaData = TeaData;
    function TeaUserAccount(teaID, userID) {
        return "TeaUserAccount|TeaID=" + teaID + "|UserID=" + userID;
    }
    MutexDefine.TeaUserAccount = TeaUserAccount;
    function Srs_UserEnter(userID) {
        return "SrsUserEnter|UserID=" + userID;
    }
    MutexDefine.Srs_UserEnter = Srs_UserEnter;
    function createRoom(roomID) {
        return "RoomCreate|RoomID=" + roomID;
    }
    MutexDefine.createRoom = createRoom;
    function UserGameRecord(userID) {
        return "UserGameRecord|UserID=" + userID;
    }
    MutexDefine.UserGameRecord = UserGameRecord;
    function LobbyDaily(userID) {
        return "Lobby|Daily|UserID=" + userID;
    }
    MutexDefine.LobbyDaily = LobbyDaily;
    function LobbyTask(userID) {
        return "Lobby|Task|UserID=" + userID;
    }
    MutexDefine.LobbyTask = LobbyTask;
    function LobbyItem(userID) {
        return "Lobby|Item|UserID=" + userID;
    }
    MutexDefine.LobbyItem = LobbyItem;
    function LobbyStore(userID) {
        return "Lobby|Store|UserID=" + userID;
    }
    MutexDefine.LobbyStore = LobbyStore;
    function LobbyRed(userID) {
        return "Lobby|Red|UserID=" + userID;
    }
    MutexDefine.LobbyRed = LobbyRed;
})(MutexDefine = exports.MutexDefine || (exports.MutexDefine = {}));
var MutexFunctional;
(function (MutexFunctional) {
    function getMutexFunc(mutexName, opt) {
        return function (func) {
            return __awaiter(this, void 0, void 0, function* () {
                if (opt.rpc == null || opt.log == null) {
                    return null;
                }
                let b = yield opt.rpc.center.callException("kds.mutex.get", mutexName, opt.timeout || 10000);
                if (!b) {
                    opt.log.oth.error("[MutexFunctional] getMutexFunc: get mutex failed mutexName = " + mutexName);
                    if (!opt.continue) {
                        return null;
                    }
                }
                let ret = null;
                try {
                    ret = yield func();
                }
                catch (error) {
                    opt.log.oth.error("[MutexFunctional] getMutexFunc: exception mutexName = " + mutexName + " error = ", error);
                }
                if (b) {
                    opt.log.center.callException("kds.mutex.release", mutexName);
                }
                return ret;
            });
        };
    }
    MutexFunctional.getMutexFunc = getMutexFunc;
    function callInMutex(mutexName, opt) {
        return __awaiter(this, void 0, void 0, function* () {
            if (opt.rpc == null || opt.log == null) {
                return null;
            }
            let b = yield opt.rpc.center.callException("kds.mutex.get", mutexName, opt.timeout || 10000);
            if (!b) {
                opt.log.oth.error("[MutexFunctional] getMutexFunc: get mutex failed mutexName = " + mutexName);
                if (!opt.continue) {
                    return null;
                }
            }
            let ret = null;
            try {
                ret = yield opt.func();
            }
            catch (error) {
                opt.log.oth.error("[MutexFunctional] getMutexFunc: exception mutexName = " + mutexName + " error = ", error);
            }
            if (b) {
                opt.rpc.center.callException("kds.mutex.release", mutexName);
            }
            return ret;
        });
    }
    MutexFunctional.callInMutex = callInMutex;
})(MutexFunctional = exports.MutexFunctional || (exports.MutexFunctional = {}));
