"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Poker = void 0;
var Poker;
(function (Poker) {
    let Suit;
    (function (Suit) {
        Suit[Suit["None"] = 0] = "None";
        Suit[Suit["Begin"] = 1] = "Begin";
        Suit[Suit["End"] = 5] = "End";
        Suit[Suit["HeiTao"] = 1] = "HeiTao";
        Suit[Suit["HongTao"] = 2] = "HongTao";
        Suit[Suit["FangPian"] = 3] = "FangPian";
        Suit[Suit["CaoHua"] = 4] = "CaoHua";
        Suit[Suit["Joker"] = 5] = "Joker";
        Suit[Suit["AD"] = 6] = "AD";
    })(Suit = Poker.Suit || (Poker.Suit = {}));
    let Value;
    (function (Value) {
        Value[Value["None"] = 0] = "None";
        Value[Value["Begin"] = 1] = "Begin";
        Value[Value["End"] = 14] = "End";
        Value[Value["V1"] = 1] = "V1";
        Value[Value["V2"] = 2] = "V2";
        Value[Value["V3"] = 3] = "V3";
        Value[Value["V4"] = 4] = "V4";
        Value[Value["V5"] = 5] = "V5";
        Value[Value["V6"] = 6] = "V6";
        Value[Value["V7"] = 7] = "V7";
        Value[Value["V8"] = 8] = "V8";
        Value[Value["V9"] = 9] = "V9";
        Value[Value["V10"] = 10] = "V10";
        Value[Value["J"] = 11] = "J";
        Value[Value["Q"] = 12] = "Q";
        Value[Value["K"] = 13] = "K";
        Value[Value["SJoker"] = 14] = "SJoker";
        Value[Value["BJoker"] = 15] = "BJoker";
        Value[Value["AD"] = 20] = "AD";
    })(Value = Poker.Value || (Poker.Value = {}));
    function isJoker(card) {
        return card.suit == Suit.Joker && (card.value == Value.BJoker || card.value == Value.SJoker);
    }
    Poker.isJoker = isJoker;
    function validCard(card) {
        return card.suit == Suit.Joker ? isJoker(card) :
            card.suit >= Suit.Begin && card.suit < Suit.End &&
                card.value >= Value.Begin && card.value < Value.End;
    }
    Poker.validCard = validCard;
})(Poker = exports.Poker || (exports.Poker = {}));
