"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerValues = exports.ServerConfig = void 0;
const path = require("path");
let kdsConfig = null;
try {
    let projDirname = path.resolve();
    let configPath = path.join(projDirname, "..", "kds-config.js");
    kdsConfig = require(configPath);
    console.log("log db config success " + JSON.stringify(kdsConfig));
    for (let config of kdsConfig.servers) {
        if (config.serviceHost.indexOf(":") >= 0) {
            let a = config.serviceHost.split(":");
            let str = a[a.length - 1];
            let port = Number.parseInt(str);
            if (!Number.isNaN(port)) {
                config.servicePort = port;
            }
        }
        if (config.wsHost.indexOf(":") >= 0) {
            let a = config.wsHost.split(":");
            let str = a[a.length - 1];
            let port = Number.parseInt(str);
            if (!Number.isNaN(port)) {
                config.wsPort = port;
            }
        }
        console.log(JSON.stringify(config));
    }
}
catch (error) {
    console.log("load server config failed " + JSON.stringify(kdsConfig));
    kdsConfig = {
        servers: [],
        values: {},
    };
}
var ServerConfig;
(function (ServerConfig) {
    function getConfig(name) {
        let arr = kdsConfig.servers;
        let ret = arr.find((v) => v.name == name);
        return ret;
    }
    ServerConfig.getConfig = getConfig;
    function getValue(name) {
        return kdsConfig == null ? null : kdsConfig.values[name];
    }
    ServerConfig.getValue = getValue;
})(ServerConfig = exports.ServerConfig || (exports.ServerConfig = {}));
var ServerValues;
(function (ServerValues) {
    ServerValues.localIp = ServerConfig.getValue("local-ip");
    ServerValues.rpcCenterHost = ServerConfig.getValue("rpc-center");
    ServerValues.rpcToken = ServerConfig.getValue("rpc-token");
    ServerValues.rpcLoggerHost = ServerConfig.getValue("rpc-logger");
    ServerValues.srsCenterHost = ServerConfig.getValue("srs-center");
    ServerValues.srsToken = ServerConfig.getValue("srs-token");
    ServerValues.dbConnectStr = ServerConfig.getValue("db-connect");
    ServerValues.dbLogger = ServerConfig.getValue("dn-logger");
    ServerValues.dbLogin = ServerConfig.getValue("dn-login");
    ServerValues.dbLobby = ServerConfig.getValue("dn-lobby");
    ServerValues.dbAccess = ServerConfig.getValue("dn-access");
    ServerValues.dbCode = ServerConfig.getValue("dn-code");
    ServerValues.dbBill = ServerConfig.getValue("dn-bill");
    ServerValues.dbBillCache = ServerConfig.getValue("dn-bill-cache");
    ServerValues.dbTea = ServerConfig.getValue("dn-tea");
    ServerValues.dbRoom = ServerConfig.getValue("dn-room");
    ServerValues.dbSrs = ServerConfig.getValue("dn-srs");
    ServerValues.logInstance = ServerConfig.getValue("log-instance");
    ServerValues.logEngine = ServerConfig.getValue("log-engine");
})(ServerValues = exports.ServerValues || (exports.ServerValues = {}));
