"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RpcOSS = void 0;
const ossManager_1 = require("../oss/ossManager");
function upload(h, ossName, fileName, base64Str) {
    return __awaiter(this, void 0, void 0, function* () {
        let entity = ossManager_1.OSSManager.getEntity(ossName);
        if (entity == null) {
            return null;
        }
        let buffer = Buffer.from(base64Str, "base64");
        let url = yield entity.upload(fileName, buffer);
        return url;
    });
}
function removePath(h, ossName, path) {
    return __awaiter(this, void 0, void 0, function* () {
        let entity = ossManager_1.OSSManager.getEntity(ossName);
        if (entity == null) {
            return false;
        }
        let objs = yield entity.listAll(path);
        if (objs && objs.length > 0) {
            yield entity.deleteMulti(objs);
            return true;
        }
        return false;
    });
}
exports.RpcOSS = {
    upload,
    removePath: removePath,
};
