"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const RoomHelper_1 = require("./RoomHelper");
const rpc_1 = require("../rpc");
const log_1 = require("../log");
const utils_1 = require("kdweb-core/lib/utils");
function getRoomAudioPath(roomID) {
    return "wmini/audio-" + roomID;
}
function getRoomChairAudioPath(roomID, chairNo) {
    return getRoomAudioPath(roomID) + "/chair-" + chairNo;
}
function getRoomChairAudioName(roomID, chairNo) {
    return getRoomChairAudioPath(roomID, chairNo) + "/audio-" + utils_1.kdutils.getMillionSecond();
}
var AudioHelper;
(function (AudioHelper) {
    function uploadToRoom(roomID, userID, fileExt, base64Str) {
        return __awaiter(this, void 0, void 0, function* () {
            let roomRealtime = yield RoomHelper_1.RoomHelper.getRoomRealtime(roomID);
            if (roomRealtime == null) {
                return null;
            }
            let userInfo = roomRealtime.userInfos.find(v => v.userID == userID);
            if (userInfo == null) {
                log_1.Log.oth.info("cannot upload audio chairNo not exist in roomID = " + roomID + " | userID = " + userID);
                return null;
            }
            let chairNo = userInfo.chairNo;
            let fileName = getRoomChairAudioName(roomID, chairNo) + fileExt;
            try {
                yield rpc_1.Rpc.center.callException("kds.oss.removePath", "ar", getRoomChairAudioPath(roomID, chairNo));
                return yield rpc_1.Rpc.center.callException("kds.oss.upload", "ar", fileName, base64Str);
            }
            catch (error) {
                log_1.Log.oth.info("upload audio failed roomID = " + roomID + " | chairNo = " + chairNo, error);
            }
            return null;
        });
    }
    AudioHelper.uploadToRoom = uploadToRoom;
    function roomFinished(roomID) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                return yield rpc_1.Rpc.center.callException("kds.oss.removePath", "ar", getRoomAudioPath(roomID));
            }
            catch (error) {
                log_1.Log.oth.info("error in audio room finished ", error);
            }
            return false;
        });
    }
    AudioHelper.roomFinished = roomFinished;
})(AudioHelper = exports.AudioHelper || (exports.AudioHelper = {}));
