"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
const protocols_1 = require("kdweb-core/lib/rpc/protocols");
const RoomDefine_1 = require("../../../kds-base-define/src/RoomDefine");
const db_1 = require("../db");
const ServerConfig_1 = require("../../../kds-base-define/src/ServerConfig");
const log_1 = require("../log");
const utils_1 = require("kdweb-core/lib/utils");
const GameSet_1 = require("../../../kds-base-define/src/GameSet");
const UserFlag_1 = require("../../../kds-base-define/src/UserFlag");
let db = db_1.DB.get(ServerConfig_1.ServerValues.dbRoom);
let roomTableName = "t_room";
let realStatusTableName = "t_real_status";
var RoomHelper;
(function (RoomHelper) {
    function getRoomID() {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.call("kds.ids.getId", "room-service", 100000, 1);
            if (ret.code == protocols_1.kdRpcMsg.CallErrorCode.Success) {
                return ret.data;
            }
            return -1;
        });
    }
    function getBoxCode() {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.call("kds.code.get", 6, "room-code");
            if (ret.code != 0) {
                log_1.Log.oth.error("[room] get room code failed", ret);
                return null;
            }
            return ret.data;
        });
    }
    function releaseBoxCode(code) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.call("kds.code.release", code, 6, "room-code");
            if (ret.code != 0) {
                log_1.Log.oth.error("[room] release room code failed", ret);
                return null;
            }
            return ret.data;
        });
    }
    function getRoomPOData(codeOrID) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                let roomPOData = yield rpc_1.Rpc.center.callException("kds.dbp.room.get", codeOrID);
                return roomPOData;
            }
            catch (error) {
                log_1.Log.oth.error("[room] cannot get roomPOData from dbp error", error);
            }
            return null;
        });
    }
    RoomHelper.getRoomPOData = getRoomPOData;
    function getRoomRealtime(codeOrID) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                let roomRealtime = yield rpc_1.Rpc.center.callException("kds.dbp.room.real.get", codeOrID);
                return roomRealtime;
            }
            catch (error) {
                log_1.Log.oth.error("[room] cannot get roomRealtime from dbp error", error);
            }
            return null;
        });
    }
    RoomHelper.getRoomRealtime = getRoomRealtime;
    function prepareRoomInfo(creatorUserID, gameData) {
        return __awaiter(this, void 0, void 0, function* () {
            let userInfo = null;
            if (creatorUserID) {
                try {
                    userInfo = yield rpc_1.Rpc.center.callException("kds.dbp.user.userInfo.get", creatorUserID);
                }
                catch (error) {
                    userInfo = null;
                    log_1.Log.oth.error(error);
                }
                if (userInfo == null) {
                    log_1.Log.oth.error("[prepareRoomInfo] call dbp failed get creator userInfo failed userID = " + creatorUserID);
                    return null;
                }
            }
            let b = false;
            try {
                b = yield rpc_1.Rpc.center.callException("kds.srs.room.verify", gameData);
            }
            catch (error) {
                log_1.Log.oth.error("[prepareRoomInfo] call srs failed", error);
            }
            if (!b) {
                log_1.Log.oth.error("[prepareRoomInfo] verify roomData failed ", gameData);
                return null;
            }
            // TODO: 支付 
            // ...
            let ret = {
                userID: 0,
                sk: ""
            };
            if (userInfo) {
                ret.userID = userInfo.userID,
                    ret.sk = userInfo.sk;
            }
            else {
                ret.userID = null;
                ret.sk = null;
            }
            return ret;
        });
    }
    function createLobbyRoom(creatorUserID, gameData) {
        return __awaiter(this, void 0, void 0, function* () {
            log_1.Log.oth.info("[createLobbyRoom] 进入到createLobbyRoom = " + creatorUserID);
            let roomID = yield rpc_1.Rpc.center.callException("kds.dbp.room.boss", creatorUserID);
            log_1.Log.oth.info("[createLobbyRoom] roomID = " + roomID);
            if (roomID != null) {
                log_1.Log.oth.info("[createLobbyRoom] have exist room id = " + roomID);
                let roomPOData = yield rpc_1.Rpc.center.callException("kds.dbp.room.get", roomID);
                if (roomPOData) {
                    return roomPOData.roomData;
                }
                log_1.Log.oth.error("[createLobbyRoom] cannot get exist room data id = " + roomID);
                return null;
            }
            log_1.Log.oth.info("[createLobbyRoom] flag = " + UserFlag_1.UserFlag.RoomID);
            roomID = yield rpc_1.Rpc.center.callException("kds.dbp.user.flag.get", creatorUserID, UserFlag_1.UserFlag.RoomID);
            log_1.Log.oth.info("[createLobbyRoom] call roomID = " + roomID);
            if (roomID != null) {
                log_1.Log.oth.info("[createLobbyRoom] user already in room id = " + roomID);
                return null;
            }
            let gameSet = new GameSet_1.GameSet(gameData.gameID, gameData.bSets, gameData.iSets);
            let payType = gameSet.getPayType();
            let prepareInfo = yield prepareRoomInfo(creatorUserID, gameData);
            if (prepareInfo == null) {
                log_1.Log.oth.error("[createLobbyRoom] prepare room info failed", gameData);
                return null;
            }
            let roomPOData = {
                boxCode: null,
                roomID: null,
                roomData: {
                    boxCode: null,
                    roomID: null,
                    bossUserID: prepareInfo.userID,
                    bossSK: prepareInfo.sk,
                    roomExt: {
                        payType: payType,
                        payValue: gameSet.getSpendMoney(),
                        roomType: RoomDefine_1.RoomDefine.RoomType.Lobby,
                    },
                    gameData: gameData,
                    teaExt: null,
                },
                createDate: utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss"),
                createTimestamp: utils_1.kdutils.getMillionSecond()
            };
            try {
                log_1.Log.oth.info("[createLobbyRoom] kds.inpay.room.create = ", JSON.stringify(roomPOData));
                let b = yield rpc_1.Rpc.center.callException("kds.inpay.room.create", roomPOData);
                if (!b) {
                    log_1.Log.oth.info("[createLobbyRoom] room create pay failed", gameData);
                    return null;
                }
                log_1.Log.oth.info("[createLobbyRoom] getRoomID");
                let roomID = yield getRoomID();
                if (roomID == null) {
                    log_1.Log.oth.error("[createLobbyRoom] get room id failed ", gameData);
                    return null;
                }
                log_1.Log.oth.info("[createLobbyRoom] getBoxCode");
                let boxCode = yield getBoxCode();
                if (boxCode == null) {
                    log_1.Log.oth.error("[createLobbyRoom] get boxCode failed ", gameData);
                    return null;
                }
                roomPOData.boxCode = boxCode;
                roomPOData.roomID = roomID;
                roomPOData.roomData.boxCode = boxCode;
                roomPOData.roomData.roomID = roomID;
            }
            catch (error) {
                log_1.Log.oth.error("[createLobbyRoom] catch exception when create ", error);
                return null;
            }
            log_1.Log.oth.info("[createLobbyRoom] kds.dbp.room.create roomPOData =>", JSON.stringify(roomPOData));
            let b = yield rpc_1.Rpc.center.callException("kds.dbp.room.create", roomPOData);
            log_1.Log.oth.info("[createLobbyRoom] kds.dbp.room.create call =>", JSON.stringify(b));
            if (!b) {
                log_1.Log.oth.error("[createLobbyRoom] create room failed, rpc call failed ", roomPOData);
                return null;
            }
            log_1.Log.oth.info("[createLobbyRoom] call lobby createRoom func  =>", JSON.stringify(roomPOData));
            return roomPOData.roomData;
        });
    }
    RoomHelper.createLobbyRoom = createLobbyRoom;
    function createTeaRoom(creatorUserID, gameData, teaExt) {
        return __awaiter(this, void 0, void 0, function* () {
            let gameSet = new GameSet_1.GameSet(gameData.gameID, gameData.bSets, gameData.iSets);
            let payType = gameSet.getPayType();
            let prepareInfo = yield prepareRoomInfo(null, gameData);
            if (prepareInfo == null) {
                log_1.Log.oth.error("[createTeaRoom] prepare room info failed", gameData);
                return null;
            }
            let roomPOData = {
                boxCode: null,
                roomID: null,
                roomData: {
                    boxCode: null,
                    roomID: null,
                    bossUserID: -2,
                    bossSK: "TEAID:" + teaExt.teaID,
                    roomExt: {
                        payType: payType,
                        payValue: gameSet.getSpendMoney(),
                        roomType: teaExt.useFund ? RoomDefine_1.RoomDefine.RoomType.Fund : RoomDefine_1.RoomDefine.RoomType.Tea,
                    },
                    gameData: gameData,
                    teaExt: teaExt,
                },
                createDate: utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss"),
                createTimestamp: utils_1.kdutils.getMillionSecond()
            };
            try {
                let b = yield rpc_1.Rpc.center.callException("kds.inpay.room.create", roomPOData);
                if (!b) {
                    log_1.Log.oth.info("[createTeaRoom] room create pay failed", gameData);
                    return null;
                }
                let roomID = yield getRoomID();
                if (roomID == null) {
                    log_1.Log.oth.error("[createTeaRoom] get room id failed ", gameData);
                    return null;
                }
                let boxCode = yield getBoxCode();
                if (boxCode == null) {
                    log_1.Log.oth.error("[createTeaRoom] get boxCode failed ", gameData);
                    return null;
                }
                roomPOData.boxCode = boxCode;
                roomPOData.roomID = roomID;
                roomPOData.roomData.boxCode = boxCode;
                roomPOData.roomData.roomID = roomID;
            }
            catch (error) {
                log_1.Log.oth.error("[createTeaRoom] catch exception when create ", error);
            }
            let b = yield rpc_1.Rpc.center.callException("kds.dbp.room.create", roomPOData);
            if (!b) {
                log_1.Log.oth.error("[createTeaRoom] create room failed, rpc call failed ", roomPOData);
                return null;
            }
            rpc_1.Rpc.center.callException("kds.nt-in.room.changed", roomPOData.roomID, RoomDefine_1.RoomDefine.RoomChangedType.TeaCreate, teaExt.teaID);
            return roomPOData.roomData;
        });
    }
    RoomHelper.createTeaRoom = createTeaRoom;
    /**
     * 删除房间，触发inpay，一般是jiesan接口或者游戏结束调用的
     * 所以这是一个通用接口，匹配场和比赛的也都会调用到这里
     * @param codeOrID
     * @param bill
     */
    function removeRoom(codeOrID, bill) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                let roomPOData = yield getRoomPOData(codeOrID);
                if (roomPOData == null) {
                    log_1.Log.oth.error("[removeRoom] get roomPOData failed codeOrID = " + codeOrID);
                    return null;
                }
                let roomRealtime = yield getRoomRealtime(codeOrID);
                if (roomRealtime == null) {
                    log_1.Log.oth.error("[removeRoom] get roomRealtime failed codeOrID = " + codeOrID);
                    return null;
                }
                log_1.Log.oth.info("[removeRoom] start =>", codeOrID);
                bill = bill || null;
                let b = yield rpc_1.Rpc.center.call("kds.inpay.room.end", roomPOData, roomRealtime, bill);
                log_1.Log.oth.info("try to remove room " + codeOrID + " inpay ret = " + b);
                roomPOData = yield rpc_1.Rpc.center.callException("kds.dbp.room.remove", codeOrID);
                if (roomPOData) {
                    let b = yield releaseBoxCode(roomPOData.boxCode);
                    if (!b) {
                        log_1.Log.oth.info("release box code failed ", roomPOData);
                    }
                    return roomPOData;
                }
            }
            catch (error) {
                log_1.Log.oth.error("[removeRoom] fail to remove room codeOrID = " + codeOrID, error);
            }
            return null;
        });
    }
    RoomHelper.removeRoom = removeRoom;
    /**
     * 直接删除房间，不触发inpay
     * @param codeOrID
     */
    function removeRoomInternal(codeOrID) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                let roomPOData = yield getRoomPOData(codeOrID);
                if (roomPOData == null) {
                    log_1.Log.oth.error("[removeRoomInternal] get roomPOData failed codeOrID = " + codeOrID);
                    return null;
                }
                let roomRealtime = yield getRoomRealtime(codeOrID);
                if (roomRealtime == null) {
                    log_1.Log.oth.error("[removeRoomInternal] get roomRealtime failed codeOrID = " + codeOrID);
                    return null;
                }
                let b = yield rpc_1.Rpc.center.callException("kds.inpay.room.end", roomPOData, roomRealtime, null);
                log_1.Log.oth.info("try to remove room " + codeOrID + " inpay ret = " + b);
                roomPOData = yield rpc_1.Rpc.center.callException("kds.dbp.room.remove", codeOrID);
                if (roomPOData) {
                    let b = yield releaseBoxCode(roomPOData.boxCode);
                    if (!b) {
                        log_1.Log.oth.info("release box code failed ", roomPOData);
                    }
                    return roomPOData;
                }
            }
            catch (error) {
                log_1.Log.oth.error("[removeRoomInternal] fail to remove room codeOrID = " + codeOrID, error);
            }
            return null;
        });
    }
    RoomHelper.removeRoomInternal = removeRoomInternal;
    function createInternalRoom(flag, gameData, opt) {
        return __awaiter(this, void 0, void 0, function* () {
            let gameSet = new GameSet_1.GameSet(gameData.gameID, gameData.bSets, gameData.iSets);
            let payType = gameSet.getPayType();
            let prepareInfo = yield prepareRoomInfo(null, gameData);
            if (prepareInfo == null) {
                log_1.Log.oth.error("[createLobbyRoom] prepare room info failed", gameData);
                return null;
            }
            let roomPOData = {
                boxCode: null,
                roomID: null,
                roomData: {
                    boxCode: null,
                    roomID: null,
                    bossUserID: -1,
                    bossSK: flag,
                    groupID: opt.groupID,
                    matchID: opt.matchID,
                    roomExt: {
                        payType: payType,
                        payValue: gameSet.getSpendMoney(),
                        roomType: RoomDefine_1.RoomDefine.RoomType.Internal,
                    },
                    gameData: gameData,
                    teaExt: null,
                },
                createDate: utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss"),
                createTimestamp: utils_1.kdutils.getMillionSecond()
            };
            try {
                // let b:boolean = await Rpc.center.callException("kds.inpay.room.create",roomPOData)
                // if(!b) {
                // 	Log.oth.info("[createLobbyRoom] room create pay failed",gameData)
                // 	return null
                // }
                let roomID = yield getRoomID();
                if (roomID == null) {
                    log_1.Log.oth.error("[createLobbyRoom] get room id failed ", gameData);
                    return null;
                }
                let boxCode = yield getBoxCode();
                if (boxCode == null) {
                    log_1.Log.oth.error("[createLobbyRoom] get boxCode failed ", gameData);
                    return null;
                }
                roomPOData.boxCode = boxCode;
                roomPOData.roomID = roomID;
                roomPOData.roomData.boxCode = boxCode;
                roomPOData.roomData.roomID = roomID;
            }
            catch (error) {
                log_1.Log.oth.error("[createLobbyRoom] catch exception when create ", error);
                return null;
            }
            let b = yield rpc_1.Rpc.center.callException("kds.dbp.room.create", roomPOData);
            if (!b) {
                log_1.Log.oth.error("[createLobbyRoom] create room failed, rpc call failed ", roomPOData);
                return null;
            }
            return roomPOData.roomData;
        });
    }
    RoomHelper.createInternalRoom = createInternalRoom;
})(RoomHelper = exports.RoomHelper || (exports.RoomHelper = {}));
