"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var RoomDefine;
(function (RoomDefine) {
    let PayType;
    (function (PayType) {
        PayType[PayType["BitTarget"] = 65535] = "BitTarget";
        PayType[PayType["BitUse"] = 4294901760] = "BitUse";
        // target 支付对象 0x0000FFFF
        // 具体支付
        PayType[PayType["Boss"] = 1] = "Boss";
        PayType[PayType["AA"] = 2] = "AA";
        PayType[PayType["Winner"] = 3] = "Winner";
        // 类型支付
        // 金币场
        PayType[PayType["CoinGame"] = 4096] = "CoinGame";
        // 比赛场，无支付
        PayType[PayType["MatchGame"] = 8192] = "MatchGame";
        // use 支付货币 0xFFFF0000
        PayType[PayType["UseCard"] = 65536] = "UseCard";
        PayType[PayType["UseDiamond"] = 131072] = "UseDiamond";
        PayType[PayType["UseGold"] = 196608] = "UseGold";
        PayType[PayType["UseGroup"] = 327680] = "UseGroup";
        PayType[PayType["UseMatch"] = 393216] = "UseMatch";
        PayType[PayType["UseMatchCoin"] = 458752] = "UseMatchCoin";
        PayType[PayType["UseMatchCoin_NoShow"] = 524288] = "UseMatchCoin_NoShow";
        // 茶馆：贡献
        PayType[PayType["UseTeaFund"] = 1114112] = "UseTeaFund";
        // 茶馆：账户
        PayType[PayType["UseTeaAccount"] = 1179648] = "UseTeaAccount";
    })(PayType = RoomDefine.PayType || (RoomDefine.PayType = {}));
    function getPayTarget(type) {
        return type & PayType.BitTarget;
    }
    RoomDefine.getPayTarget = getPayTarget;
    function getPayUse(type) {
        return type & PayType.BitUse;
    }
    RoomDefine.getPayUse = getPayUse;
    RoomDefine.watchChairNoStart = 10000;
    let RoomType;
    (function (RoomType) {
        RoomType[RoomType["Lobby"] = 0] = "Lobby";
        RoomType[RoomType["Tea"] = 1] = "Tea";
        RoomType[RoomType["Fund"] = 2] = "Fund";
        RoomType[RoomType["Internal"] = 3] = "Internal";
        RoomType[RoomType["Match"] = 4] = "Match";
    })(RoomType = RoomDefine.RoomType || (RoomDefine.RoomType = {}));
    let RoomStatusType;
    (function (RoomStatusType) {
        RoomStatusType[RoomStatusType["Virtual"] = 0] = "Virtual";
        RoomStatusType[RoomStatusType["Wait"] = 1] = "Wait";
        RoomStatusType[RoomStatusType["Running"] = 2] = "Running";
        RoomStatusType[RoomStatusType["End"] = 3] = "End";
    })(RoomStatusType = RoomDefine.RoomStatusType || (RoomDefine.RoomStatusType = {}));
    let RoomChangedType;
    (function (RoomChangedType) {
        RoomChangedType[RoomChangedType["Add"] = 0] = "Add";
        RoomChangedType[RoomChangedType["Update"] = 1] = "Update";
        RoomChangedType[RoomChangedType["Remove"] = 2] = "Remove";
        RoomChangedType[RoomChangedType["Start"] = 3] = "Start";
        RoomChangedType[RoomChangedType["TeaCreate"] = 4] = "TeaCreate";
    })(RoomChangedType = RoomDefine.RoomChangedType || (RoomDefine.RoomChangedType = {}));
    function getDistance(loc1, loc2) {
        let p = 0.017453292519943295; //Pi/180
        let a = 0.5 - Math.cos((loc2.lat - loc1.lat) * p) / 2 + Math.cos(loc1.lat * p) * Math.cos(loc2.lat * p) * (1 - Math.cos((loc2.lon - loc1.lon) * p)) / 2;
        let dist = 12742 * Math.asin(Math.sqrt(a)); // 2*R*asin...
        return dist * 1000;
    }
    RoomDefine.getDistance = getDistance;
})(RoomDefine = exports.RoomDefine || (exports.RoomDefine = {}));
