"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const manager_1 = require("kdweb-core/lib/rpc/manager");
const rpc_1 = require("../rpc");
const user_1 = require("../helper/user");
const SrsDefine_1 = require("../../../kds-base-define/src/SrsDefine");
const log_1 = require("../log");
var NodeStatus;
(function (NodeStatus) {
    NodeStatus[NodeStatus["Normal"] = 0] = "Normal";
    NodeStatus[NodeStatus["GreyTest"] = 1] = "GreyTest";
    NodeStatus[NodeStatus["Disabled"] = 2] = "Disabled";
})(NodeStatus = exports.NodeStatus || (exports.NodeStatus = {}));
class SrsCenterNodeRpcEntity extends manager_1.kdRpcManager.entity {
    constructor(params) {
        super(params);
        this.srsNodes_ = [];
    }
    onRpcServerClosed(h, client) {
        super.onRpcServerClosed(h, client);
        user_1.UserHelper.nodeClosed(client.name);
        let idx = this.srsNodes_.findIndex((v) => v.client.name == client.name);
        if (idx >= 0) {
            let node = this.srsNodes_[idx];
            log_1.Log.oth.info("[center-node] srs node lose connect node = ", node);
            this.srsNodes_.splice(idx, 1);
        }
    }
    onRpcServerReg(h, client) {
        super.onRpcServerReg(h, client);
        this.srsNodes_.push({
            client: client,
            otherConfig: null,
            status: NodeStatus.Normal,
        });
        log_1.Log.oth.info("[center-node] srs node reg success client = ", client);
        this._getNodeOtherConfig(client.name);
    }
    get nodeOtherConfigs() {
        let ret = [];
        for (let info of this.srsNodes_) {
            if (info.otherConfig) {
                ret.push({
                    name: info.client.name,
                    tag: info.client.tag,
                    centerHost: info.client.host,
                    otherConfig: info.otherConfig,
                });
            }
        }
        return ret;
    }
    getNodeStatus(name) {
        let info = this.srsNodes_.find(v => v.client.name == name);
        return info == null ? NodeStatus.Disabled : info.status;
    }
    setNodeStatus(name, s) {
        let info = this.srsNodes_.find(v => v.client.name == name);
        if (info) {
            info.status = s;
            return true;
        }
        return false;
    }
    getNodeOtherConfig(name) {
        let info = this.srsNodes_.find(v => v.client.name == name);
        return info != null ? info.otherConfig : null;
    }
    getNodeSrsInfo(name) {
        return this.srsNodes_.find(v => v.client.name == name);
    }
    _refreshSrsInfo() {
        return __awaiter(this, void 0, void 0, function* () {
            let nodeNames = [];
            let infos = this.clients;
            for (let info of infos) {
                nodeNames.push(info.name);
            }
            yield rpc_1.Rpc.center.callException("kds.dbp.srs.refreshAll", nodeNames, infos);
        });
    }
    _getNodeOtherConfig(name) {
        return __awaiter(this, void 0, void 0, function* () {
            let info = this.srsNodes_.find((v) => v.client.name == name);
            if (info == null) {
                return null;
            }
            let otherConfig = yield this.callException(SrsDefine_1.SrsInternal.getSrsNodeApiPrefix(name) + ".getOtherConfig");
            if (otherConfig == null) {
                log_1.Log.oth.error("[center-node] get other config failed name = " + name);
                return null;
            }
            info.otherConfig = otherConfig;
            log_1.Log.oth.info("[center-node] handle node other config node = ", info);
            this._refreshSrsInfo();
            return otherConfig;
        });
    }
}
exports.SrsCenterNodeRpcEntity = SrsCenterNodeRpcEntity;
