"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
// 如果center重启怎么办？
let users = [];
let userDirty = false;
// let dbProcessing = false 
// async function dbProcess() {
// 	dbProcessing = true 
// 	let tableName = "t_srs_center_user_nodes"
// 	let db = DB.get(ServerValues.dbSrs)
// 	await db.delMany(tableName,{})
// 	await db.insert(tableName,users)
// 	dbProcessing = false 
// }
// async function dbInit() {
// 	let tableName = "t_srs_center_user_nodes"
// 	let db = DB.get(ServerValues.dbSrs)
// 	users = await db.get(tableName,{})
// 	if(users == null) {
// 		Log.oth.error("[user] init srs user nodes failed")
// 		users = []
// 		userDirty = true 
// 	}
// 	UserHelper.waitInit.resolve()
// 	UserHelper.waitInit = null
// }
// UserHelper.waitInit.promise.then(function() {
// 	setInterval(function() {
// 		if(dbProcessing) {
// 			return 
// 		}
// 		if(userDirty) {
// 			userDirty = false 
// 			dbProcess()
// 		}
// 	},100)
// })
// dbInit()
var UserHelper;
(function (UserHelper) {
    function findUserInNode(userID) {
        let user = users.find((v) => v.userID == userID);
        return user == null ? null : user.nodeName;
    }
    UserHelper.findUserInNode = findUserInNode;
    function getUserNode(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield rpc_1.Rpc.center.callException("kds.dbp.user.node.get", userID);
        });
    }
    UserHelper.getUserNode = getUserNode;
    // function _regUser(userID:number, nodeName:string) {
    // 	let user = users.find((v)=>v.userID == userID)
    // 	if(user) {
    // 		user.nodeName = nodeName
    // 	} else {
    // 		user = {
    // 			userID:userID,
    // 			nodeName:nodeName,
    // 		}
    // 		users.push(user)
    // 		userDirty = true 
    // 	}
    // }
    function regUser(userID, nodeName) {
        return __awaiter(this, void 0, void 0, function* () {
            // if(waitInit) {
            // 	waitInit.promise.then(function() {
            // 		_regUser(userID,nodeName)
            // 	})
            // } else {
            // 	_regUser(userID,nodeName)
            // }
            yield rpc_1.Rpc.center.callException("kds.dbp.user.node.set", userID, nodeName);
            return true;
        });
    }
    UserHelper.regUser = regUser;
    function unRegUser(userID, nodeName) {
        return __awaiter(this, void 0, void 0, function* () {
            // if(waitInit != null) {
            // 	Log.oth.error("[user] unreg: not init userID = " + userID + " name = " + nodeName)
            // 	return false 
            // }
            // let idx = users.findIndex((v)=>v.userID == userID)
            // if(idx < 0) {
            // 	return true 
            // }
            // let user = users[idx]
            // if(user.nodeName == nodeName) {
            // 	users.splice(idx,1)
            // 	userDirty = true 
            // 	return true 
            // }
            // Log.oth.error("[user] unReg: find user in node not eq name = " + nodeName,user)
            // return false 
            let b = yield rpc_1.Rpc.center.callException("kds.dbp.user.node.remove", userID, nodeName);
            return b;
        });
    }
    UserHelper.unRegUser = unRegUser;
    // node 失去连接，删除与node有关的玩家信息
    function nodeClosed(nodeName) {
        return __awaiter(this, void 0, void 0, function* () {
            // Log.oth.info("[user] handle node closed name = " + nodeName)
            // let count = 0
            // for(let i = users.length - 1; i >= 0 ; i--) {
            // 	let user = users[i]
            // 	if(user.nodeName == nodeName) {
            // 		users.splice(i,1)
            // 		count ++
            // 	}
            // }
            // Log.oth.info("[user] clear user node status count = " + count)
            // if(count > 0) {
            // 	userDirty = true 
            // }
            yield rpc_1.Rpc.center.callException("kds.dbp.user.node.removeNode", nodeName);
        });
    }
    UserHelper.nodeClosed = nodeClosed;
    function unRegAllUser() {
        users = [];
        userDirty = true;
    }
    UserHelper.unRegAllUser = unRegAllUser;
    UserHelper.waitInit = null; //new kdasync.wait()
})(UserHelper = exports.UserHelper || (exports.UserHelper = {}));
