"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
const SrsDefine_1 = require("../../../kds-base-define/src/SrsDefine");
function setGameServerStatus(h, gsTag, s) {
    return __awaiter(this, void 0, void 0, function* () {
        rpc_1.Rpc.nodeServer.callAll(SrsDefine_1.SrsInternal.NodeSide.setGameServerStatus, gsTag, s);
        return true;
    });
}
function getGameServerStatus(h, gsTag) {
    return __awaiter(this, void 0, void 0, function* () {
        let res = yield rpc_1.Rpc.nodeServer.callAll(SrsDefine_1.SrsInternal.NodeSide.getGameServerStatus, gsTag);
        let ret = [];
        for (let r of res) {
            ret.push({
                name: r.clientInfo.name,
                gsStatus: r.data,
            });
        }
        return ret;
    });
}
function getAllGameServerStatus(h) {
    return __awaiter(this, void 0, void 0, function* () {
        let res = yield rpc_1.Rpc.nodeServer.callAll(SrsDefine_1.SrsInternal.NodeSide.getAllGameServerStatus);
        let ret = [];
        for (let r of res) {
            ret.push({
                name: r.clientInfo.name,
                gss: r.data,
            });
        }
        return ret;
    });
}
exports.RpcGS = {
    setGameServerStatus,
    getGameServerStatus,
    getAllGameServerStatus,
};
