"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
const utils_1 = require("kdweb-core/lib/utils");
const user_1 = require("../helper/user");
const log_1 = require("../log");
const SrsDefine_1 = require("../../../kds-base-define/src/SrsDefine");
const centerNodeRpcEntity_1 = require("../center/centerNodeRpcEntity");
const UserFlag_1 = require("../../../kds-base-define/src/UserFlag");
function getAllNodes(h) {
    return __awaiter(this, void 0, void 0, function* () {
        let clients = rpc_1.Rpc.nodeServer.clients;
        for (let client of clients) {
            client["status"] = rpc_1.Rpc.nodeServer.getNodeStatus(client.name);
            client["otherConfig"] = rpc_1.Rpc.nodeServer.getNodeOtherConfig(client.name);
        }
        return clients;
    });
}
function getAllEnabledNodes(h) {
    return __awaiter(this, void 0, void 0, function* () {
        let clients = yield getAllNodes(h);
        let ret = [];
        for (let client of clients) {
            if (client["status"] != centerNodeRpcEntity_1.NodeStatus.Normal) {
                continue;
            }
            ret.push(client);
        }
        return ret;
    });
}
function getAllNodesByStatus(h, status) {
    return __awaiter(this, void 0, void 0, function* () {
        let clients = yield getAllNodes(h);
        let ret = [];
        for (let client of clients) {
            if (client["status"] != status) {
                continue;
            }
            ret.push(client);
        }
        return ret;
    });
}
function selectNodeHost(h, userID, areaID) {
    return __awaiter(this, void 0, void 0, function* () {
        let clients = yield getAllEnabledNodes(h);
        let selOtherConfigs = [];
        let isCompany = false;
        try {
            isCompany = yield rpc_1.Rpc.center.callException("kds.dbp.user.flag.get", userID, UserFlag_1.UserFlag.CompanyTest);
        }
        catch (error) {
            isCompany = false;
            log_1.Log.oth.error("[realtime] get user company failed userID = " + userID, error);
        }
        if (isCompany) {
            for (let client of clients) {
                let nodeInfo = rpc_1.Rpc.nodeServer.getNodeSrsInfo(client.name);
                if (nodeInfo.otherConfig == null) {
                    continue;
                }
                let areaCheck = (nodeInfo.otherConfig.group == null)
                    ||
                        (areaID != null
                            &&
                                nodeInfo.otherConfig.group != null
                            &&
                                areaID == nodeInfo.otherConfig.group.toString());
                if (nodeInfo.otherConfig.company && areaCheck) {
                    selOtherConfigs.push(nodeInfo.otherConfig);
                }
            }
        }
        else {
            for (let client of clients) {
                let nodeInfo = rpc_1.Rpc.nodeServer.getNodeSrsInfo(client.name);
                if (nodeInfo.otherConfig == null) {
                    continue;
                }
                let areaCheck = (nodeInfo.otherConfig.group == null)
                    ||
                        (areaID != null
                            &&
                                nodeInfo.otherConfig.group != null
                            &&
                                areaID == nodeInfo.otherConfig.group.toString());
                if (!nodeInfo.otherConfig.company && areaCheck) {
                    selOtherConfigs.push(nodeInfo.otherConfig);
                }
            }
        }
        if (selOtherConfigs.length == 0) {
            log_1.Log.oth.error("[realtime] cannot get srsNodeHost other config is empty userID = " + userID);
            return null;
        }
        let config = selOtherConfigs[utils_1.kdutils.intRandom(0, selOtherConfigs.length)];
        return config.userHost;
    });
}
function getNodeStatus(h, name) {
    return __awaiter(this, void 0, void 0, function* () {
        return rpc_1.Rpc.nodeServer.getNodeStatus(name);
    });
}
function setNodeStatus(h, name, status) {
    return __awaiter(this, void 0, void 0, function* () {
        return rpc_1.Rpc.nodeServer.setNodeStatus(name, status);
    });
}
function getUserCount(h) {
    return __awaiter(this, void 0, void 0, function* () {
        let res = yield rpc_1.Rpc.nodeServer.callAll(SrsDefine_1.SrsInternal.NodeSide.getUserCount);
        if (res == null || res.length == 0) {
            return 0;
        }
        let count = 0;
        let arr = [];
        for (let r of res) {
            arr.push({
                name: r.clientInfo.name,
                count: r.data
            });
            count += r.data;
        }
        return {
            arr: arr,
            totalCount: count,
        };
    });
}
function getNodeUserInfo(h) {
    return __awaiter(this, void 0, void 0, function* () {
        let res = yield rpc_1.Rpc.nodeServer.callAll(SrsDefine_1.SrsInternal.NodeSide.getNodeUserInfos);
        if (res == null || res.length == 0) {
            return 0;
        }
        let arr = [];
        for (let r of res) {
            arr.push({
                name: r.clientInfo.name,
                userConnectionInfos: r.data
            });
        }
        return {
            arr: arr,
        };
    });
}
function findUser(h, userID) {
    return __awaiter(this, void 0, void 0, function* () {
        let nodeName = yield user_1.UserHelper.getUserNode(userID);
        if (nodeName) {
            return rpc_1.Rpc.nodeServer.clients.find((v) => v.name == nodeName);
        }
        return null;
    });
}
// gs name
function checkRoom(h, codeOrID) {
    return __awaiter(this, void 0, void 0, function* () {
        let gsName = yield rpc_1.Rpc.nodeServer.callException(SrsDefine_1.SrsInternal.NodeSide.checkRoom, codeOrID);
        return gsName;
    });
}
function sendToUser(h, userID, msgName, jsonObj) {
    return __awaiter(this, void 0, void 0, function* () {
        let nodeName = yield user_1.UserHelper.getUserNode(userID);
        if (nodeName == null) {
            log_1.Log.oth.error("[realtime] cannot send to user msgName = " + msgName);
            return false;
        }
        try {
            let b = yield rpc_1.Rpc.nodeServer.callException(SrsDefine_1.SrsInternal.getSrsNodeApiPrefix(nodeName) + ".sendToUser", userID, msgName, jsonObj);
            return b;
        }
        catch (error) {
            log_1.Log.oth.error("[realtime] sendToUser: call node failed name = " + nodeName, error);
        }
        return false;
    });
}
function jiesanRoom(h, codeOrID) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            let b = yield rpc_1.Rpc.nodeServer.callException(SrsDefine_1.SrsInternal.NodeSide.jiesanRoom, codeOrID);
            return b;
        }
        catch (error) {
            log_1.Log.oth.error("[realtime] jiesanRoom: call node failed codeOrID = " + codeOrID, error);
        }
        return false;
    });
}
function updateUserData(h, userID) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            let b = yield rpc_1.Rpc.nodeServer.callException(SrsDefine_1.SrsInternal.NodeSide.updateUserData, userID);
            return b;
        }
        catch (error) {
            log_1.Log.oth.error("[realtime] updateUserData: call node failed userID = " + userID, error);
        }
        return false;
    });
}
function userChargeRoom(h, userID, score) {
    return __awaiter(this, void 0, void 0, function* () {
        let nodeName = yield user_1.UserHelper.getUserNode(userID);
        if (nodeName == null) {
            log_1.Log.oth.error("[realtime] cannot charge to user userID = " + userID + " | score = " + score);
            return -1;
        }
        try {
            return yield rpc_1.Rpc.nodeServer.callException(SrsDefine_1.SrsInternal.getSrsNodeApiPrefix(nodeName) + ".userChargeRoom", userID, score);
        }
        catch (error) {
            log_1.Log.oth.error("[realtime] userChargeRoom: call node failed name = " + nodeName, error);
        }
        return -1;
    });
}
function kickUser(h, userID) {
    return __awaiter(this, void 0, void 0, function* () {
        let nodeName = yield user_1.UserHelper.getUserNode(userID);
        if (nodeName == null) {
            log_1.Log.oth.error("[realtime] cannot find user to kick = " + userID);
            return false;
        }
        try {
            return yield rpc_1.Rpc.nodeServer.callException(SrsDefine_1.SrsInternal.getSrsNodeApiPrefix(nodeName) + ".kickUser", userID);
        }
        catch (error) {
            log_1.Log.oth.error("[realtime] kickUser: call node failed name = " + nodeName, error);
        }
        return false;
    });
}
exports.RpcSrsRealtime = {
    getAllNodes,
    getAllEnabledNodes,
    getAllNodesByStatus,
    selectNodeHost,
    setNodeStatus,
    getNodeStatus,
    getUserCount,
    getNodeUserInfo,
    findUser,
    checkRoom,
    sendToUser,
    jiesanRoom,
    userChargeRoom,
    kickUser,
    updateUserData,
};
