"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const centerClient_1 = require("kdweb-core/lib/rpc/center/centerClient");
const ServerConfig_1 = require("../../kds-base-define/src/ServerConfig");
const config_1 = require("./config");
const wechat_1 = require("./rpc/wechat");
const award_1 = require("./rpc/award");
const NotifyDefine_1 = require("../../kds-base-define/src/NotifyDefine");
const listen_1 = require("./rpc/listen");
const room_1 = require("./rpc/room");
const roomHelper_1 = require("./wechat/roomHelper");
var Rpc;
(function (Rpc) {
    Rpc.room = new roomHelper_1.RoomHelper;
    function init() {
        if (ServerConfig_1.ServerValues.localIp) {
            centerClient_1.kdRpcCenterClient.setupLocalHostReplacement(ServerConfig_1.ServerValues.localIp);
        }
        Rpc.center = new centerClient_1.kdRpcCenterClient.entity({
            centerHost: ServerConfig_1.ServerValues.rpcCenterHost,
            port: config_1.Config.myConfig.wsPort,
            token: ServerConfig_1.ServerValues.rpcToken,
            info: {
                name: config_1.Config.myName,
                tag: config_1.Config.myName,
                host: config_1.Config.myConfig.wsHost,
                auth: "DDD",
                version: "1.0",
                timestamp: 0,
                data: null
            }
        });
        Rpc.center.logUrlPath = ServerConfig_1.ServerValues.rpcLoggerHost;
        Rpc.center.addGroup("kds.wechat", wechat_1.RpcWechat);
        Rpc.center.addGroup("kds.wechat.pay", wechat_1.RpcWechatPay);
        Rpc.center.addGroup("kds.wechat.award", award_1.RpcAward);
        Rpc.center.addGroup("kds.wechat.room", room_1.RpcRoom);
        Rpc.center.addGroup(NotifyDefine_1.NotifyDefine.ListenPrefix, listen_1.RpcNTServiceListen);
    }
    Rpc.init = init;
})(Rpc = exports.Rpc || (exports.Rpc = {}));
