"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const wcore = require("kdweb-core");
const base_1 = require("kdweb-core/lib/service/base");
const config_1 = require("./config");
const rpc_1 = require("./rpc");
const callback_1 = require("./wechat/callback");
const service_1 = require("./wechat/service");
let app = new wcore.service.entity(config_1.Config.myConfig.servicePort);
for (let config of config_1.Config.localConfig.games) {
    if (config.callback) {
        app.addInstance(config.callback.prefix, new callback_1.WechatCallback.Verify(config.gameName));
        app.addInstance(config.callback.prefix, new callback_1.WechatCallback.Service(config.gameName));
        app.addInstance(config.callback.prefix, base_1.lambdaAsyncService.create(service_1.WechatService.imageCheck));
    }
}
app.listen();
rpc_1.Rpc.init();
