"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const base_1 = require("kdweb-core/lib/service/base");
const CryptoJS = require("crypto-js");
const config_1 = require("../config");
const log_1 = require("../log");
const utils_1 = require("kdweb-core/lib/utils");
function getSign(data, token) {
    data.token = token;
    let keys = Object.keys(data);
    let values = [];
    for (let k of keys) {
        values.push(data[k]);
    }
    values.sort();
    let str = values.join("");
    return CryptoJS.SHA1(str).toString();
}
var WechatCallback;
(function (WechatCallback) {
    class Verify extends base_1.baseService {
        constructor(gameName) {
            super();
            this.gameName_ = gameName;
        }
        get protoType() {
            return base_1.ProtoType.GET;
        }
        onReq(req, res) {
            let t = req.query;
            let data = {
                timestamp: t.timestamp,
                nonce: t.nonce
            };
            log_1.Log.oth.info("receive wechat verify gameName = " + this.gameName_);
            log_1.Log.oth.info("wechat verify t = ", t);
            let config = config_1.Config.localConfig.games.find(v => v.gameName == this.gameName_);
            let sign = getSign(data, config.callback.token);
            log_1.Log.oth.info("sign = " + sign);
            if (sign == t.signature) {
                res.send(t.echostr);
                return;
            }
            res.send("");
        }
    }
    WechatCallback.Verify = Verify;
    class Service extends base_1.jsonAsyncService {
        constructor(token) {
            super();
            this.token_ = token;
        }
        onJsonReq(params, res) {
            this.work(params)
                .then(function (ret) {
                if (ret == null) {
               //     res.send("success");
			   res.send("success zhb new");
                    return;
                }
                res.send(ret);
            });
        }
        work(params) {
            return __awaiter(this, void 0, void 0, function* () {
                log_1.Log.oth.info("receive wechat callback body = ", params);
                if (params.Event == "user_enter_tempsession") {
                    // 				let ret = `
                    // <xml>
                    //     <ToUserName><![CDATA[{0}]]></ToUserName>
                    //     <FromUserName><![CDATA[{1}]]></FromUserName>
                    //     <CreateTime>{2}</CreateTime>
                    //     <MsgType><![CDATA[transfer_customer_service]]></MsgType>
                    // </xml>
                    // `
                    // 				let ret = 
                    // `
                    // <xml>
                    // 	<ToUserName>{0}</ToUserName>
                    // 	<FromUserName>{1}</FromUserName>
                    // 	<CreateTime>{2}</CreateTime>
                    // 	<MsgType>transfer_customer_service</MsgType>
                    // </xml>
                    // `
                    // 				ret = kdutils.format(ret,params.FromUserName,"BFPQMJ001",Math.floor(kdutils.getMillionSecond() / 1000))
                    // 				Log.oth.info("transform wechat custom msg ret = " + ret)
                    // 				return <any>ret 
                    let ret = {
                        ToUserName: params.FromUserName,
                        FromUserName: "BFPQMJ001",
                        CreateTime: Math.floor(utils_1.kdutils.getMillionSecond() / 1000),
                        MsgType: "transfer_customer_service",
                    };
                    log_1.Log.oth.info("transform wechat custom msg ret = ", ret);
                    return ret;
                }
                return null;
            });
        }
    }
    WechatCallback.Service = Service;
})(WechatCallback = exports.WechatCallback || (exports.WechatCallback = {}));
