"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
const service_1 = require("../wechat/service");
function getShareID(h, gameName, roomID) {
    return __awaiter(this, void 0, void 0, function* () {
        let id = yield rpc_1.Rpc.room.getShareID(gameName, roomID);
        if (id == null) {
            id = yield rpc_1.Rpc.room.createShareID(gameName, roomID, true);
        }
        return id;
    });
}
function updateShareInfo(h, gameName, roomID, state, curUserCount, maxUserCount) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield rpc_1.Rpc.room.updateRoomShareInfo(gameName, roomID, state, curUserCount.toString(), maxUserCount.toString());
    });
}
function msgCheck(h, gameName, content) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield service_1.WechatService.msgSecCheck(gameName, content);
    });
}
exports.RpcRoom = {
    getShareID,
    updateShareInfo,
    msgCheck,
};
