"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
const log_1 = require("../log");
const utils_1 = require("kdweb-core/lib/utils");
const async_1 = require("kdweb-core/lib/tools/async");
const service_1 = require("./service");
const RoomDefine_1 = require("../../../kds-base-define/src/RoomDefine");
const config_1 = require("../config");
const GameSet_1 = require("../../../kds-base-define/src/GameSet");
let tableName = "t_wechat_shareid";
let createMutex = [];
function getKey(gameName, roomID) {
    return gameName + "|" + roomID;
}
class RoomHelper {
    getShareID(gameName, roomID) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                let id = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", tableName, getKey(gameName, roomID));
                return id;
            }
            catch (error) {
                log_1.Log.oth.error("[room] get id failed ", error);
            }
            return null;
        });
    }
    createShareID(gameName, roomID, noCheck) {
        return __awaiter(this, void 0, void 0, function* () {
            let id = null;
            if (!noCheck) {
                id = yield this.getShareID(gameName, roomID);
                if (id) {
                    return id;
                }
            }
            let key = getKey(gameName, roomID);
            if (createMutex.indexOf(key) >= 0) {
                let time = utils_1.kdutils.getMillionSecond();
                while (true) {
                    yield async_1.kdasync.timeout(50);
                    if (createMutex.indexOf(key) < 0) {
                        break;
                    }
                    if (utils_1.kdutils.getMillionSecond() - time > 5000) {
                        return null;
                    }
                }
                let id = this.getShareID(gameName, roomID);
                if (id) {
                    return id;
                }
            }
            createMutex.push(key);
            try {
                id = yield service_1.WechatService.createActivityId(gameName);
                if (id) {
                    yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", tableName, key, id);
                }
            }
            catch (error) {
                log_1.Log.oth.error("[room] create share id failed ", error);
            }
            let idx = createMutex.indexOf(key);
            createMutex.splice(idx, 1);
            return id;
        });
    }
    updateRoomShareInfo(gameName, roomID, state, curUserCount, maxUserCount) {
        return __awaiter(this, void 0, void 0, function* () {
            let id = yield this.getShareID(gameName, roomID);
            if (id == null) {
                return false;
            }
            return yield service_1.WechatService.updateActivityInfo(gameName, id, {
                state: state,
                member_count: curUserCount,
                room_limit: maxUserCount,
                roomID: roomID,
            });
        });
    }
    removeRoomShareID(gameName, roomID, id) {
        return __awaiter(this, void 0, void 0, function* () {
            id = id || (yield this.getShareID(gameName, roomID));
            if (id == null) {
                return false;
            }
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.delt", tableName, getKey(gameName, roomID));
            yield service_1.WechatService.removeActivityInfo(gameName, id);
            return true;
        });
    }
    onRoomChanged(roomID, changeType) {
        return __awaiter(this, void 0, void 0, function* () {
            log_1.Log.oth.info("[room] room changed roomID = " + roomID + " | type = " + RoomDefine_1.RoomDefine.RoomChangedType[changeType]);
            let gameName = config_1.Config.localConfig.defaultGameName;
            if (changeType == RoomDefine_1.RoomDefine.RoomChangedType.Update) {
                let roomFullData = yield rpc_1.Rpc.center.callException("kds.dbp.room.getFull", roomID);
                if (roomFullData == null) {
                    yield this.removeRoomShareID(gameName, roomID);
                    return false;
                }
                if (roomFullData.roomRealtime.status == RoomDefine_1.RoomDefine.RoomStatusType.Wait) {
                    let userCount = 0;
                    for (let userInfo of roomFullData.roomRealtime.userInfos) {
                        if (userInfo.chairNo >= 10000) {
                            continue;
                        }
                        userCount++;
                    }
                    let gameData = roomFullData.roomPOData.roomData.gameData;
                    let gameSet = new GameSet_1.GameSet(gameData.gameID, gameData.bSets, gameData.iSets);
                    yield this.updateRoomShareInfo(gameName, roomID, 0, userCount.toString(), gameSet.getUserCount().toString());
                }
                else {
                    yield this.updateRoomShareInfo(gameName, roomID, 1, "0", "0");
                    yield this.removeRoomShareID(gameName, roomID);
                }
            }
            else if (changeType == RoomDefine_1.RoomDefine.RoomChangedType.Remove) {
                yield this.updateRoomShareInfo(gameName, roomID, 1, "0", "0");
                yield this.removeRoomShareID(gameName, roomID);
            }
        });
    }
}
exports.RoomHelper = RoomHelper;
